package com.bokesoft.yes.meta.persist.dom.form.component.control.properties;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.def.LabelLineBreakType;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaLabelProperties;

public class MetaLabelPropertiesAction extends DomPropertiesAction<MetaLabelProperties> {

	@Override
	public void loadImpl(Document document, Element element,
			MetaLabelProperties meta, int runType) {
		meta.setIcon(DomHelper.readAttr(element, MetaConstants.COMMON_ICON, ""));
		meta.setSingleLine(DomHelper.readAttr(element, MetaConstants.COMMON_SIGNLELINE, true));
		meta.setLineBreakMode(LabelLineBreakType.parse(
				DomHelper.readAttr(element, MetaConstants.COMMON_BREAKLINEMODE, LabelLineBreakType.STR_ENDHIDE)));
		meta.setMaxLines(DomHelper.readAttr(element, MetaConstants.COMMON_MAXLINES, -1));
		meta.setExpandCaption(DomHelper.readAttr(element, MetaConstants.LABEL_EXPANDCAPTION, ""));
	}

	@Override
	public void saveImpl(Document document, Element element,
			MetaLabelProperties meta, int runType) {
		DomHelper.writeAttr(element, MetaConstants.COMMON_ICON, meta.getIcon(), "");
		DomHelper.writeAttr(element, MetaConstants.COMMON_SIGNLELINE, meta.isSingleLine(), true);
		DomHelper.writeAttr(element, MetaConstants.COMMON_BREAKLINEMODE,
				LabelLineBreakType.toString(meta.getLineBreakMode()), LabelLineBreakType.STR_ENDHIDE);
		DomHelper.writeAttr(element, MetaConstants.COMMON_MAXLINES, meta.getMaxLines(), -1);
		DomHelper.writeAttr(element, MetaConstants.LABEL_EXPANDCAPTION, meta.getExpandCaption(), "");
	}

}
