package com.bokesoft.yes.meta.persist.dom.form.component.control.properties;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.def.LocationType;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaButtonProperties;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaHoverButtonProperties;

public class MetaHoverButtonPropertiesAction extends MetaButtonPropertiesAction{

	@Override
	public void loadImpl(Document document, Element element, MetaButtonProperties meta, int runType) {
		super.loadImpl(document, element, meta, runType);
		MetaHoverButtonProperties metaHoverButton = (MetaHoverButtonProperties)meta;
		metaHoverButton.setLocation(LocationType.parse(DomHelper.readAttr(element, MetaConstants.HOVERBUTTON_LOCATION, LocationType.STR_RIGHT + LocationType.SEPARATOR + LocationType.STR_BOTTOM)));
	}

	@Override
	public void saveImpl(Document document, Element element, MetaButtonProperties meta, int runType) {
		super.saveImpl(document, element, meta, runType);
		MetaHoverButtonProperties metaHoverButton = (MetaHoverButtonProperties)meta;
		DomHelper.writeAttr(element, MetaConstants.HOVERBUTTON_LOCATION, LocationType.toString(metaHoverButton.getLocation()), LocationType.STR_RIGHT + LocationType.SEPARATOR + LocationType.STR_BOTTOM);
		
	}
}
