package com.bokesoft.yes.meta.persist.dom.form.component.control.properties;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaDropdownButtonProperties;

public class MetaDropdownButtonPropertiesAction extends DomPropertiesAction<MetaDropdownButtonProperties> {

	@Override
	public void loadImpl(Document document, Element element,
			MetaDropdownButtonProperties meta, int runType) {
		meta.setIcon(DomHelper.readAttr(element, MetaConstants.COMMON_ICON, ""));
		meta.setCssClass(DomHelper.readAttr(element, MetaConstants.OPERATION_CSSCLASS, ""));
	}

	@Override
	public void saveImpl(Document document, Element element,
			MetaDropdownButtonProperties meta, int runType) {
		DomHelper.writeAttr(element, MetaConstants.COMMON_ICON, meta.getIcon(), "");
		DomHelper.writeAttr(element, MetaConstants.OPERATION_CSSCLASS, meta.getCssClass(), "");
	}

}
