package com.bokesoft.yes.meta.persist.dom.form.component.control.properties;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaAttachmentProperties;

public class MetaAttachmentPropertiesAction extends DomPropertiesAction<MetaAttachmentProperties> {

	@Override
	public void loadImpl(Document document, Element element,
			MetaAttachmentProperties meta, int runType) {
		meta.setImpl(DomHelper.readAttr(element, MetaConstants.ATTACHMENT_IMPL, ""));
		meta.setTableKey(DomHelper.readAttr(element, MetaConstants.ATTACHMENT_TABLEKEY, ""));
		meta.setMaxSize(DomHelper.readAttr(element, MetaConstants.ATTACHMENT_MAXSIZE, -1));
		meta.setProvider(DomHelper.readAttr(element, MetaConstants.ATTACHMENT_PROVIDER, ""));
		meta.setAllowedTypes(DomHelper.readAttr(element, MetaConstants.ATTACHMENT_TYPES, ""));
		meta.setPreview(DomHelper.readAttr(element, MetaConstants.ATTACHMENT_PREVIEW, false));
	}
	
	@Override
	public void saveImpl(Document document, Element element,
			MetaAttachmentProperties meta, int runType) {
		DomHelper.writeAttr(element, MetaConstants.ATTACHMENT_IMPL, meta.getImpl(), "");	
		DomHelper.writeAttr(element, MetaConstants.ATTACHMENT_TABLEKEY, meta.getTableKey(), "");
		DomHelper.writeAttr(element, MetaConstants.ATTACHMENT_PROVIDER, meta.getProvider(), "");
		DomHelper.writeAttr(element, MetaConstants.ATTACHMENT_TYPES, meta.getAllowedTypes(), "");
		DomHelper.writeAttr(element, MetaConstants.ATTACHMENT_MAXSIZE, meta.getMaxSize(), -1);		
		DomHelper.writeAttr(element, MetaConstants.ATTACHMENT_PREVIEW, meta.isPreview(), false);		
	}

}
