package com.bokesoft.yes.meta.persist.dom.form.component.control.extend;

import java.util.HashMap;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.BaseDomAction;
import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yes.meta.persist.dom.form.component.control.properties.MetaButtonPropertiesAction;
import com.bokesoft.yes.meta.persist.dom.form.component.control.properties.MetaCheckBoxPropertiesAction;
import com.bokesoft.yes.meta.persist.dom.form.component.control.properties.MetaCheckListBoxPropertiesAction;
import com.bokesoft.yes.meta.persist.dom.form.component.control.properties.MetaComboBoxPropertiesAction;
import com.bokesoft.yes.meta.persist.dom.form.component.control.properties.MetaCountDownViewPropertiesAction;
import com.bokesoft.yes.meta.persist.dom.form.component.control.properties.MetaDatePickerPropertiesAction;
import com.bokesoft.yes.meta.persist.dom.form.component.control.properties.MetaDictPropertiesAction;
import com.bokesoft.yes.meta.persist.dom.form.component.control.properties.MetaEmptyPropertiesAction;
import com.bokesoft.yes.meta.persist.dom.form.component.control.properties.MetaGIFImagePropertiesAction;
import com.bokesoft.yes.meta.persist.dom.form.component.control.properties.MetaHyperLinkPropertiesAction;
import com.bokesoft.yes.meta.persist.dom.form.component.control.properties.MetaIconPropertiesAction;
import com.bokesoft.yes.meta.persist.dom.form.component.control.properties.MetaImageListPropertiesAction;
import com.bokesoft.yes.meta.persist.dom.form.component.control.properties.MetaImagePropertiesAction;
import com.bokesoft.yes.meta.persist.dom.form.component.control.properties.MetaLabelPropertiesAction;
import com.bokesoft.yes.meta.persist.dom.form.component.control.properties.MetaMonthPickerPropertiesAction;
import com.bokesoft.yes.meta.persist.dom.form.component.control.properties.MetaNumberEditorPropertiesAction;
import com.bokesoft.yes.meta.persist.dom.form.component.control.properties.MetaNumberInfoEditorPropertiesAction;
import com.bokesoft.yes.meta.persist.dom.form.component.control.properties.MetaPasswordEditorPropertiesAction;
import com.bokesoft.yes.meta.persist.dom.form.component.control.properties.MetaProgressBarPropertiesAction;
import com.bokesoft.yes.meta.persist.dom.form.component.control.properties.MetaProgressIndicatorPropertiesAction;
import com.bokesoft.yes.meta.persist.dom.form.component.control.properties.MetaScoreBarPropertiesAction;
import com.bokesoft.yes.meta.persist.dom.form.component.control.properties.MetaSegmentedControlPropertiesAction;
import com.bokesoft.yes.meta.persist.dom.form.component.control.properties.MetaSliderPropertiesAction;
import com.bokesoft.yes.meta.persist.dom.form.component.control.properties.MetaStepEditorPropertiesAction;
import com.bokesoft.yes.meta.persist.dom.form.component.control.properties.MetaSwitchPropertiesAction;
import com.bokesoft.yes.meta.persist.dom.form.component.control.properties.MetaTextAreaPropertiesAction;
import com.bokesoft.yes.meta.persist.dom.form.component.control.properties.MetaTextEditorPropertiesAction;
import com.bokesoft.yes.meta.persist.dom.form.component.control.properties.MetaTimePickerPropertiesAction;
import com.bokesoft.yes.meta.persist.dom.form.component.control.properties.MetaUTCDatePickerPropertiesAction;
import com.bokesoft.yes.meta.persist.dom.form.component.control.properties.extend.MetaButtonExtPropertiesAction;
import com.bokesoft.yes.meta.persist.dom.form.component.control.properties.extend.MetaCheckBoxExtPropertiesAction;
import com.bokesoft.yes.meta.persist.dom.form.component.control.properties.extend.MetaCheckListBoxExtPropertiesAction;
import com.bokesoft.yes.meta.persist.dom.form.component.control.properties.extend.MetaComboBoxExtPropertiesAction;
import com.bokesoft.yes.meta.persist.dom.form.component.control.properties.extend.MetaDatePickerExtPropertiesAction;
import com.bokesoft.yes.meta.persist.dom.form.component.control.properties.extend.MetaDictExtPropertiesAction;
import com.bokesoft.yes.meta.persist.dom.form.component.control.properties.extend.MetaHyperLinkExtPropertiesAction;
import com.bokesoft.yes.meta.persist.dom.form.component.control.properties.extend.MetaImageExtPropertiesAction;
import com.bokesoft.yes.meta.persist.dom.form.component.control.properties.extend.MetaLabelExtPropertiesAction;
import com.bokesoft.yes.meta.persist.dom.form.component.control.properties.extend.MetaMonthPickerExtPropertiesAction;
import com.bokesoft.yes.meta.persist.dom.form.component.control.properties.extend.MetaNumberEditorExtPropertiesAction;
import com.bokesoft.yes.meta.persist.dom.form.component.control.properties.extend.MetaNumberInfoEditorExtPropertiesAction;
import com.bokesoft.yes.meta.persist.dom.form.component.control.properties.extend.MetaPasswordEditorExtPropertiesAction;
import com.bokesoft.yes.meta.persist.dom.form.component.control.properties.extend.MetaStepEditorExtPropertiesAction;
import com.bokesoft.yes.meta.persist.dom.form.component.control.properties.extend.MetaTextAreaExtPropertiesAction;
import com.bokesoft.yes.meta.persist.dom.form.component.control.properties.extend.MetaTextEditorExtPropertiesAction;
import com.bokesoft.yes.meta.persist.dom.form.component.control.properties.extend.MetaTimePickerExtPropertiesAction;
import com.bokesoft.yes.meta.persist.dom.form.component.control.properties.extend.MetaUTCDatePickerExtPropertiesAction;
import com.bokesoft.yigo.common.def.ControlType;
import com.bokesoft.yigo.common.def.DefSize;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.form.component.control.listview.MetaListViewColumn;

public class MetaListViewColumnExtAction extends BaseDomAction<MetaListViewColumn> {
	private HashMap<Integer, BaseDomAction<AbstractMetaObject>> actionMap = null;
	@SuppressWarnings("unchecked")
	public MetaListViewColumnExtAction() {
		super();
		actionMap = new HashMap<Integer, BaseDomAction<AbstractMetaObject>>();
		Object[][] v = new Object[][] {
				{ ControlType.LABEL, new MetaLabelExtPropertiesAction() },
				{ ControlType.TEXTAREA, new MetaTextAreaExtPropertiesAction() },
				{ ControlType.CHECKBOX, new MetaCheckBoxExtPropertiesAction() },
				{ ControlType.HYPERLINK, new MetaHyperLinkExtPropertiesAction() },
				{ ControlType.BUTTON, new MetaButtonExtPropertiesAction() },
				{ ControlType.DATEPICKER, new MetaDatePickerExtPropertiesAction() },
				{ ControlType.DICT, new MetaDictExtPropertiesAction() },
				{ ControlType.NUMBEREDITOR, new MetaNumberEditorExtPropertiesAction() },
				{ ControlType.TEXTEDITOR, new MetaTextEditorExtPropertiesAction() },
				{ ControlType.COMBOBOX, new MetaComboBoxExtPropertiesAction() },
				{ ControlType.CHECKLISTBOX, new MetaCheckListBoxExtPropertiesAction() },
				{ ControlType.IMAGE, new MetaImageExtPropertiesAction() },
				{ ControlType.UTCDATEPICKER, new MetaUTCDatePickerExtPropertiesAction() },
				{ ControlType.STEPEDITOR, new MetaStepEditorExtPropertiesAction() },
				{ ControlType.ICON, new MetaIconExtPropertiesAction() },
				{ ControlType.TEXTAREA, new MetaTextAreaExtPropertiesAction() },
				{ ControlType.PASSWORDEDITOR, new MetaPasswordEditorExtPropertiesAction() },
				{ ControlType.NUMBERINFOEDITOR, new MetaNumberInfoEditorExtPropertiesAction() },
				{ ControlType.MONTHPICKER, new MetaMonthPickerExtPropertiesAction() },
				{ ControlType.TIMEPICKER, new MetaTimePickerExtPropertiesAction() },
				
				
				//  TODO 实现ExtendPropertiesAction
				{ ControlType.IMAGEBUTTON, new MetaButtonPropertiesAction() },
				{ ControlType.SCOREBAR, new MetaScoreBarPropertiesAction() },
				{ ControlType.SWITCH, new MetaSwitchPropertiesAction() },
				{ ControlType.SEGMENTEDCONTROL, new MetaSegmentedControlPropertiesAction() },
				{ ControlType.PROGRESSINDICATOR, new MetaProgressIndicatorPropertiesAction() },
				{ ControlType.PROGRESSBAR, new MetaProgressBarPropertiesAction() },
				{ ControlType.SLIDER, new MetaSliderPropertiesAction() },
				{ ControlType.COUNTDOWNVIEW, new MetaCountDownViewPropertiesAction() },
				{ ControlType.GIFIMAGE, new MetaGIFImagePropertiesAction() },
				{ ControlType.IMAGELIST, new MetaImageListPropertiesAction() },
				{ ControlType.EMPTY, new MetaEmptyPropertiesAction() }
		};
		int length = v.length;
		for ( int i = 0; i<length; ++i ) {
			Object[] l = v[i];
			Integer type = (Integer)l[0];
			BaseDomAction<AbstractMetaObject> action = (BaseDomAction<AbstractMetaObject>)l[1];
			actionMap.put(type, action);
		}
	}
	
	@Override
	public void load(Document document, Element element, MetaListViewColumn meta, int runType) {
		meta.setKey(DomHelper.readAttr(element, MetaConstants.COMMON_KEY, ""));
		meta.setColumnType(ControlType.parse(DomHelper.readAttr(element, MetaConstants.LISTVIEW_COLUMNTYPE, ControlType.STR_LABEL)));
		
		meta.setCaption(DomHelper.readAttr(element, MetaConstants.COMMON_CAPTION, null));
		meta.setDataColumnKey(DomHelper.readAttr(element, MetaConstants.LISTVIEW_COLUMN_DATACOLUMNKEY, null));
		meta.setWidth(DefSize.parse(DomHelper.readAttr(element, MetaConstants.LISTVIEW_COLUMN_WIDTH, "")));
		meta.setTableKey(DomHelper.readAttr(element, MetaConstants.LISTVIEW_COLUMN_TABLEKEY, null));
		meta.setDefaultValue(DomHelper.readAttr(element, MetaConstants.COMMON_DEFAULTVALUE, null));
		meta.setDefaultFormulaValue(DomHelper.readAttr(element, MetaConstants.COMMON_DEFAULTFORMULAVALUE, null));
		meta.setEnable(DomHelper.readAttr(element, MetaConstants.COMMON_ENABLE, null));
		meta.setVisible(DomHelper.readAttr(element, MetaConstants.COMMON_VISIBLE, null));
		meta.setSelect(DomHelper.readBool(element, MetaConstants.IS_SELECT, null));
		meta.setSingleSelect(DomHelper.readBool(element, MetaConstants.SINGLE_SELECT, null));
		meta.setWrapText(DomHelper.readBool(element, MetaConstants.LISTVIEW_COLUMN_WRAPTEXT, null));
		meta.setSortable(DomHelper.readBool(element, MetaConstants.SORTABLE, null));

		meta.ensureProperties();
		
		BaseDomAction<AbstractMetaObject> action = actionMap.get(meta.getColumnType());
		if ( action != null ) {
			action.load(document, element, meta.getProperties(), runType);
		}
	}

	@Override
	public void save(Document document, Element element, MetaListViewColumn meta, int runType) {

	}

}
