package com.bokesoft.yes.meta.persist.dom.form.component.control;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yes.meta.persist.dom.form.component.MetaComponentAction;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.form.component.control.MetaFlatCanvas;

public class MetaFlatCanvasAction extends MetaComponentAction<MetaFlatCanvas> {

	@Override
	public void load(Document document, Element element, MetaFlatCanvas meta, int runType) {
		super.load(document, element, meta, runType);
		meta.setSource(DomHelper.readAttr(element, MetaConstants.FLATCANVAS_SOURCE, ""));
	}
	
	@Override
	public void save(Document document, Element element, MetaFlatCanvas meta, int runType) {
		super.save(document, element, meta, runType);
		DomHelper.writeAttr(element, MetaConstants.FLATCANVAS_SOURCE, meta.getSource(), "");
	}
}


