package com.bokesoft.yes.meta.persist.dom.form.component.control;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yes.meta.persist.dom.form.component.MetaComponentAction;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.common.util.TypeConvertor;
import com.bokesoft.yigo.meta.form.component.control.MetaCalendar;

public class MetaCalendarAction extends MetaComponentAction<MetaCalendar> {

	@Override
	public void load(Document document, Element element, MetaCalendar meta, int runType) {
		super.load(document, element, meta, runType);
		String maxDateStr = DomHelper.readAttr(element, MetaConstants.CANLENDER_MAX_DATE, null);
		if(maxDateStr != null){
			meta.setMaxDate(TypeConvertor.toLong(maxDateStr));
		}
		String minDateStr = DomHelper.readAttr(element, MetaConstants.CANLENDER_MIN_DATE, null);
		if(minDateStr != null){
			meta.setMinDate(TypeConvertor.toLong(minDateStr));
		}
		String allowStr = DomHelper.readAttr(element, MetaConstants.CANLENDER_ALLOWMULTISELECTION, null);
		if(allowStr != null){
			meta.setAllowMultiSelection(TypeConvertor.toBoolean(allowStr));
		}
	}
	
	@Override
	public void save(Document document, Element element, MetaCalendar meta, int runType) {
		super.save(document, element, meta, runType);
		DomHelper.writeAttr(element, MetaConstants.CANLENDER_MAX_DATE, meta.getMaxDate()+"", MetaCalendar.DEFAULT_MAX_DATE+"");
		DomHelper.writeAttr(element, MetaConstants.CANLENDER_MIN_DATE, meta.getMinDate()+"", MetaCalendar.DEFAULT_MIN_DATE+"");
		DomHelper.writeAttr(element, MetaConstants.CANLENDER_ALLOWMULTISELECTION, meta.isAllowMultiSelection(), false);
	}
	
}
