package com.bokesoft.yes.meta.persist.dom.form.component;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.BaseDomAction;
import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.def.HAlignment;
import com.bokesoft.yigo.common.def.VAlignment;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.form.component.MetaFormat;

public class MetaFormatAction extends BaseDomAction<MetaFormat> {

	@Override
	public void load(Document document, Element element, MetaFormat meta, int runType) {
		meta.setForeColor(DomHelper.readAttr(element, MetaConstants.FORMAT_FORECOLOR, ""));
		meta.setBackColor(DomHelper.readAttr(element, MetaConstants.FORMAT_BACKCOLOR, ""));
		meta.setHighlightBackColor(DomHelper.readAttr(element, MetaConstants.FORMAT_HIGHLIGHTCOLOR, ""));
		meta.setHAlign(HAlignment.parse(DomHelper.readAttr(element, MetaConstants.FORMAT_HALIGN,"")));
		meta.setVAlign(VAlignment.parse(DomHelper.readAttr(element, MetaConstants.FORMAT_VALIGN, VAlignment.STR_CENTER)));
	}

	@Override
	public void save(Document document, Element element, MetaFormat meta, int runType) {
		DomHelper.writeAttr(element, MetaConstants.FORMAT_FORECOLOR, meta.getForeColor(), "");
		DomHelper.writeAttr(element, MetaConstants.FORMAT_BACKCOLOR, meta.getBackColor(), "");
		DomHelper.writeAttr(element, MetaConstants.FORMAT_HIGHLIGHTCOLOR, meta.getHighlightBackColor(), "");
		DomHelper.writeAttr(element, MetaConstants.FORMAT_HALIGN, HAlignment.toString(meta.getHAlign()), "");
		DomHelper.writeAttr(element, MetaConstants.FORMAT_VALIGN, VAlignment.toString(meta.getVAlign()), VAlignment.STR_CENTER);
	}

}
