package com.bokesoft.yes.meta.persist.dom.form.component;

import org.apache.commons.lang3.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.BaseDomAction;
import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.def.DefSize;
import com.bokesoft.yigo.common.def.DirectionType;
import com.bokesoft.yigo.common.def.HAlignment;
import com.bokesoft.yigo.common.def.Position;
import com.bokesoft.yigo.common.def.VAlignment;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.form.component.MetaComponent;

/**
 * 所以控件的基础类对象在保存和载入时的相关动作
 *
 * @author 陈志盛
 * @since YES1.0
 */
public class MetaComponentExtAction<T extends MetaComponent> extends BaseDomAction<T> {
    protected BaseDomAction<AbstractMetaObject> propertiesAction = null;

    @Override
    public void load(Document document, Element element, T meta, int runType) {
        meta.setKey(DomHelper.readAttr(element, MetaConstants.COMMON_KEY, null));
		meta.setFormulaCaption(DomHelper.readAttr(element, MetaConstants.COMMON_FORMULACAPTION, null));
		meta.setCaptionDependency(DomHelper.readAttr(element, MetaConstants.COMMON_CAPTIONDEPENDENCY, null));
        meta.setCaption(DomHelper.readAttr(element, MetaConstants.COMMON_CAPTION, null));
        meta.setCaptionFull(DomHelper.readAttr(element, MetaConstants.COMMON_CAPTION_FULL, null));
        meta.setCaptionEn(DomHelper.readAttr(element, MetaConstants.COMMON_CAPTION_EN, null));
        meta.setCaptionEnFull(DomHelper.readAttr(element, MetaConstants.COMMON_CAPTION_EN_FULL, null));
        meta.setBuddyKey(DomHelper.readAttr(element, MetaConstants.COMPONENT_BUDDYKEY, null));
        meta.setBindingCellKey(DomHelper.readAttr(element, MetaConstants.BINDINGCELLKEY, null));
        meta.setX(DomHelper.readInt(element, MetaConstants.COMPONENT_X, null));
        meta.setY(DomHelper.readInt(element, MetaConstants.COMPONENT_Y, null));
        meta.setXSpan(DomHelper.readInt(element, MetaConstants.COMPONENT_XSPAN, null));
        meta.setYSpan(DomHelper.readInt(element, MetaConstants.COMPONENT_YSPAN, null));
        meta.setPosition(Position.parse(DomHelper.readAttr(element, MetaConstants.COMPONENT_POSITION, "")));
        meta.setArea(DirectionType.parse(DomHelper.readAttr(element, MetaConstants.COMPONENT_AREA, "")));
        meta.setLeft(DomHelper.readInt(element, MetaConstants.COMPONENT_LEFT, null));
        meta.setTop(DomHelper.readInt(element, MetaConstants.COMPONENT_TOP, null));
        meta.setRight(DomHelper.readInt(element, MetaConstants.COMPONENT_RIGHT, null));
        meta.setBottom(DomHelper.readInt(element, MetaConstants.COMPONENT_BOTTOM, null));
        meta.setFloatType(DirectionType.parse(DomHelper.readAttr(element, MetaConstants.COMPONENT_FLOAT, "")));
        meta.setTabOrder(DomHelper.readInt(element, MetaConstants.TAB_ORDER, null));
        String width = DomHelper.readAttr(element, MetaConstants.COMMON_WIDTH, null);
        if (width != null && !width.isEmpty()) {
            meta.setWidth(DefSize.parse(width));
        }else{
            meta.setWidth(null);
        }
        String height = DomHelper.readAttr(element, MetaConstants.COMMON_HEIGHT, null);
        if (height != null && !height.isEmpty()) {
            meta.setHeight(DefSize.parse(height));
        }else{
            meta.setHeight(null);
        }
        String minHeight = DomHelper.readAttr(element, MetaConstants.COMMON_MINHEIGHT, null);
        if ( minHeight != null && !minHeight.isEmpty() ) {
            meta.setMinHeight(DefSize.parse(minHeight));
        }else{
            meta.setMinHeight(null);
        }

        meta.setPadding(DomHelper.readAttr(element, MetaConstants.COMPONENT_PADDING, null));
        meta.setTopPadding(DomHelper.readAttr(element, MetaConstants.COMPONENT_TOPPADDING, null));
        meta.setRightPadding(DomHelper.readAttr(element, MetaConstants.COMPONENT_RIGHTPADDING, null));
        meta.setBottomPadding(DomHelper.readAttr(element, MetaConstants.COMPONENT_BOTTOMPADDING, null));
        meta.setLeftPadding(DomHelper.readAttr(element, MetaConstants.COMPONENT_LEFTPADDING, null));

        meta.setMargin(DomHelper.readAttr(element, MetaConstants.COMPONENT_MARGIN, null));
        meta.setTopMargin(DomHelper.readAttr(element, MetaConstants.COMPONENT_TOPMARGIN, null));
        meta.setRightMargin(DomHelper.readAttr(element, MetaConstants.COMPONENT_RIGHTMARGIN, null));
        meta.setBottomMargin(DomHelper.readAttr(element, MetaConstants.COMPONENT_BOTTOMMARGIN, null));
        meta.setLeftMargin(DomHelper.readAttr(element, MetaConstants.COMPONENT_LEFTMARGIN, null));

        meta.setHAlign(HAlignment.parse(DomHelper.readAttr(element, MetaConstants.COMPONENT_HALIGN, "")));
        meta.setVAlign(VAlignment.parse(DomHelper.readAttr(element, MetaConstants.COMPONENT_VALIGN, "")));
        String cssClass = DomHelper.readAttr(element, MetaConstants.COMPONENT_CLASS, null);
        if (StringUtils.isEmpty(cssClass)) {
            cssClass = DomHelper.readAttr(element, MetaConstants.OPERATION_CSSCLASS, null);
        }
        meta.setCssClass(cssClass);

        meta.setBorderColor(DomHelper.readAttr(element, MetaConstants.COMPONENT_BORDERCOLOR, null));
        meta.setBorderRadius(DomHelper.readAttr(element, MetaConstants.COMPONENT_BORDERRADIUS, null));
        meta.setBorderStyle(DomHelper.readAttr(element, MetaConstants.COMPONENT_BORDERWIDTH, null));
        meta.setBorderStyle(DomHelper.readAttr(element, MetaConstants.COMPONENT_BORDERSTYLE, null));
        String weight = DomHelper.readAttr(element, MetaConstants.COMPONENT_WEIGHT, "");
        if (weight != null && !weight.isEmpty()) {
            meta.setWeight(Float.parseFloat(weight));
        } else {
            meta.setWeight(null);
        }

        meta.setAsQuery(DomHelper.readBool(element, MetaConstants.COMPONENT_ASQUERY, null));
        meta.setClearable(DomHelper.readBool(element, MetaConstants.COMMON_CLEARABLE, null));
        meta.setCopyNew(DomHelper.readBool(element, MetaConstants.COMPONENT_COPYNEW, null));

        meta.setEnable(DomHelper.readAttr(element, MetaConstants.COMMON_ENABLE, null));
        meta.setEnableDependency(DomHelper.readAttr(element, MetaConstants.COMMON_ENABLE_DEPENDENCY, null));

        meta.setVisible(DomHelper.readAttr(element, MetaConstants.COMMON_VISIBLE, null));
        meta.setVisibleDependency(DomHelper.readAttr(element, MetaConstants.COMMON_VISIBLE_DEPENDENCY, null));

        meta.setToolTip(DomHelper.readAttr(element, MetaConstants.COMPONENT_TOOLTIP, null));
        meta.setFormulaTip(DomHelper.readAttr(element, MetaConstants.COMPONENT_FORMULATIP, null));

        meta.setInitEnable(DomHelper.readBool(element, MetaConstants.COMMON_INITENABLE, null));
        meta.setInitVisible(DomHelper.readBool(element, MetaConstants.COMMON_INITVISIBLE, null));
        meta.setOnlyShow(DomHelper.readBool(element, MetaConstants.COMPONENT_ONLYSHOW, null));
        meta.setCompStyle(DomHelper.readAttr(element, MetaConstants.COMPONENT_COMPSTYLE, null));
        meta.setOneTimeCompute(DomHelper.readBool(element, MetaConstants.COMPONENT_ONETIMECOMPUTE, null));

        if ( propertiesAction != null && meta.getProperties() != null ) {
            meta.setParameterID(DomHelper.readAttr(element, "ParameterID", null));
            meta.setSetParameter(DomHelper.readBool(element, "SetParameter", null));
            meta.setGetParameter(DomHelper.readBool(element, "GetParameter", null));
            propertiesAction.load(document, element, meta.getProperties(), runType);
        }

    }

    @Override
    public void save(Document document, Element element, T meta, int runType) {

    }
}