package com.bokesoft.yes.meta.persist.dom.form;

import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.AbstractSave;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaActionMap;
import com.bokesoft.yigo.meta.form.component.i18n.MetaI18nItem;

/**
 * 窗口配置对象的保存
 * 
 * @author chenzs
 * 
 */
public class MetaFormSave extends AbstractSave {

	public Object prepare(AbstractMetaObject meta, Object node) {
		Element element = (Element) node;
		Element resultElement = null;
		// 如果是需要独立节点的元数据对象，则需要创建一个新节点
		if ( meta.isStandaloneNode() ) {
		
			resultElement = document.createElement(meta instanceof MetaI18nItem ? ((MetaI18nItem)meta).getKey() : meta.getTagName());
			
			element.appendChild(resultElement);
		} else {
			// 否则使用当前节点
			resultElement = element;
		}

		return resultElement;
	}
	
	public MetaFormSave(AbstractMetaObject rootMetaObject) {
		super(rootMetaObject);
	}

	@Override
	protected IMetaActionMap getActionMap() {
		return MetaFormActionMap.getInstance();
	}

}
