package com.bokesoft.yes.meta.persist.dom.form;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.common.MetaBaseScriptAction;
import com.bokesoft.yigo.common.def.AppEventTriggerType;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.form.MetaEventHandler;

public class MetaEventHandlerAction extends MetaBaseScriptAction<MetaEventHandler> {
	@Override
	public void load(Document document, Element element, MetaEventHandler meta, int runType) {
		super.load(document, element, meta, runType);
		meta.setTrigger(AppEventTriggerType.parse(DomHelper.readAttr(element, MetaConstants.EVENT_HANDLER_TRIGGER, "")));
		meta.setMergeEvent(DomHelper.readAttr(element, MetaConstants.EVENT_HANDLER_MERGEEVENT, false));
	}

	@Override
	public void save(Document document, Element element, MetaEventHandler meta, int runType) {
		super.save(document, element, meta, runType);
		DomHelper.writeAttr(element, MetaConstants.EVENT_HANDLER_TRIGGER, AppEventTriggerType.toString(meta.getTrigger()), "");
		DomHelper.writeAttr(element, MetaConstants.EVENT_HANDLER_MERGEEVENT, meta.isMergeEvent(), false);
	}
}
