package com.bokesoft.yes.meta.persist.dom.form;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.BaseDomAction;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.form.MetaBlock;

/**
 * 所有控件集合对象在保存和载入时的相关动作
 * 
 * @author chenzs
 * @since YES1.0
 */
public class MetaBlockAction extends BaseDomAction<MetaBlock> {

	@Override
	public void load(Document document, Element element, MetaBlock meta, int runType) {
		meta.setKey(DomHelper.readAttr(element, MetaConstants.COMMON_KEY, ""));
		meta.setIsRoot(DomHelper.readAttr(element, "Root", true));
	}

	@Override
	public void save(Document document, Element element, MetaBlock meta, int runType) {
		DomHelper.writeAttr(element, "Key", meta.getKey(), "");
		DomHelper.writeAttr(element, "Root", meta.isRoot(), true);
	}

}
