package com.bokesoft.yes.meta.persist.dom.excel;

import com.bokesoft.yes.meta.persist.dom.MetaActionMap;
import com.bokesoft.yigo.meta.exceltemplate.MetaExcelBorder;
import com.bokesoft.yigo.meta.exceltemplate.MetaExcelCell;
import com.bokesoft.yigo.meta.exceltemplate.MetaExcelColumn;
import com.bokesoft.yigo.meta.exceltemplate.MetaExcelColumnExpand;
import com.bokesoft.yigo.meta.exceltemplate.MetaExcelColumns;
import com.bokesoft.yigo.meta.exceltemplate.MetaExcelDisplay;
import com.bokesoft.yigo.meta.exceltemplate.MetaExcelFont;
import com.bokesoft.yigo.meta.exceltemplate.MetaExcelFormat;
import com.bokesoft.yigo.meta.exceltemplate.MetaExcelListItem;
import com.bokesoft.yigo.meta.exceltemplate.MetaExcelRow;
import com.bokesoft.yigo.meta.exceltemplate.MetaExcelRows;
import com.bokesoft.yigo.meta.exceltemplate.MetaExcelSheet;
import com.bokesoft.yigo.meta.exceltemplate.MetaExcelWorkbook;

public class MetaExcelTemplateActionMap extends MetaActionMap {

	@Override
	protected Object[][] getActionLookupTable() {
		return new Object[][] {
				{ MetaExcelWorkbook.TAG_NAME, new MetaExcelWorkbookAction() },
				{ MetaExcelSheet.TAG_NAME, new MetaSheetAction() },
				{ MetaExcelRows.TAG_NAME, new MetaExcelRowsAction() },
				{ MetaExcelRow.TAG_NAME, new MetaExcelRowAction() },
				{ MetaExcelColumns.TAG_NAME, new MetaExcelColumnsAction() },
				{ MetaExcelColumn.TAG_NAME, new MetaExcelColumnAction() },
				{ MetaExcelCell.TAG_NAME, new MetaExcelCellAction() },
				{ MetaExcelColumnExpand.TAG_NAME, new MetaExcelColumnExpandAction() },
				{ MetaExcelDisplay.TAG_NAME, new MetaExcelDisplayAction()},
				{ MetaExcelFormat.TAG_NAME, new MetaExcelFormatAction()},
				{ MetaExcelFont.TAG_NAME, new MetaExcelFontAction()},
				{ MetaExcelBorder.TAG_NAME, new MetaExcelBorderAction()},
				{ MetaExcelListItem.TAG_NAME, new MetaExcelListItemAction()},
		};
	}
	
	private static MetaExcelTemplateActionMap INSTANCE = null;
	public static MetaExcelTemplateActionMap getInstance() {
		if (INSTANCE == null) {
			synchronized (MetaExcelTemplateActionMap.class) {
				if (INSTANCE == null) {
					INSTANCE = new MetaExcelTemplateActionMap();
				}
			}
		}

		return INSTANCE;
	}
	@Override
	protected Object[][] getHostActionLookupTable() {
		return null;
	}
}
