package com.bokesoft.yes.meta.persist.dom.excel;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.BaseDomAction;
import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.def.HAlignment;
import com.bokesoft.yigo.common.def.VAlignment;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.exceltemplate.MetaExcelDisplay;
import com.bokesoft.yigo.meta.exceltemplate.MetaExcelTemplateConstants;

public class MetaExcelDisplayAction extends BaseDomAction<MetaExcelDisplay> {

	@Override
	public void load(Document document, Element element, MetaExcelDisplay meta, int runType) {
		meta.setHAlign(HAlignment.parse(DomHelper.readAttr(element, MetaExcelTemplateConstants.DISPLAY_HALIGN, HAlignment.STR_CENTER)));
		meta.setVAlign(VAlignment.parse(DomHelper.readAttr(element, MetaExcelTemplateConstants.DISPLAY_VALIGN, VAlignment.STR_CENTER)));
		meta.setBackColor(DomHelper.readAttr(element, MetaConstants.FORMAT_BACKCOLOR, ""));
		meta.setForeColor(DomHelper.readAttr(element, MetaConstants.FORMAT_FORECOLOR, ""));
		meta.setWrapText(DomHelper.readAttr(element, MetaExcelTemplateConstants.DISPLAY_WRAPTEXT, false));
	}

	@Override
	public void save(Document document, Element element, MetaExcelDisplay meta, int runType) {
		DomHelper.writeAttr(element, MetaExcelTemplateConstants.DISPLAY_HALIGN, HAlignment.toString(meta.getHAlign()), HAlignment.STR_CENTER);
		DomHelper.writeAttr(element, MetaExcelTemplateConstants.DISPLAY_VALIGN, VAlignment.toString(meta.getVAlign()), VAlignment.STR_CENTER);
		DomHelper.writeAttr(element, MetaConstants.FORMAT_BACKCOLOR, meta.getBackColor(), "");
		DomHelper.writeAttr(element, MetaConstants.FORMAT_FORECOLOR, meta.getForeColor(), "");
		DomHelper.writeAttr(element, MetaExcelTemplateConstants.DISPLAY_WRAPTEXT, meta.isWrapText(), false);
	}

}
