package com.bokesoft.yes.meta.persist.dom.dataobject;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.BaseDomAction;
import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.def.OIDFilterType;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.dataobject.MetaOIDFilter;

public class MetaOIDFilterAction extends BaseDomAction<MetaOIDFilter> {

	@Override
	public void load(Document document, Element element, MetaOIDFilter meta,
			int runType) {
		meta.setType(OIDFilterType.parse(DomHelper.readAttr(element, MetaConstants.COMMON_TYPE, "")));
		meta.setFormula(DomHelper.readAttr(element, MetaConstants.OIDFILTER_FORMULA, ""));
		meta.setImpl(DomHelper.readAttr(element, MetaConstants.OIDFILTER_IMPL, ""));
		
	}

	@Override
	public void save(Document document, Element element, MetaOIDFilter meta,
			int runType) {
		DomHelper.writeAttr(element, MetaConstants.COMMON_TYPE, OIDFilterType.toString(meta.getType()), "");
		DomHelper.writeAttr(element, MetaConstants.OIDFILTER_FORMULA, meta.getFormula(), "");
		DomHelper.writeAttr(element, MetaConstants.OIDFILTER_IMPL, meta.getImpl(), "");
	}

}
