package com.bokesoft.yes.meta.persist.dom.dataobject;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.BaseDomAction;
import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.schema.MetaIndex;

public class MetaIndexAction extends BaseDomAction<MetaIndex> {

	@Override
	public void load(Document document, Element element, MetaIndex meta, int runType) {
		meta.setKey(DomHelper.readAttr(element, MetaConstants.COMMON_KEY, ""));
		meta.setColumns(DomHelper.readAttr(element, MetaConstants.INDEX_COLUMNS, ""));
		meta.setDescription(DomHelper.readAttr(element, MetaConstants.COMMON_DESCRIPTION, ""));
		meta.setUnique(DomHelper.readAttr(element, MetaConstants.INDEX_IS_UNIQUE, false));
	}

	@Override
	public void save(Document document, Element element, MetaIndex meta, int runType) {
		DomHelper.writeAttr(element, MetaConstants.COMMON_KEY, meta.getKey(), "");
		DomHelper.writeAttr(element, MetaConstants.INDEX_COLUMNS, meta.getColumns(), "");
		DomHelper.writeAttr(element, MetaConstants.COMMON_DESCRIPTION, meta.getDescription(), "");
		DomHelper.writeAttr(element, MetaConstants.INDEX_IS_UNIQUE, meta.isUnique(), false);
	}

}
