package com.bokesoft.yes.meta.persist.dom.dataobject;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.BaseDomAction;
import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.dataobject.MetaBatchPersist;

public class MetaBatchPersistAction extends BaseDomAction<MetaBatchPersist> {

	@Override
	public void load(Document document, Element element, MetaBatchPersist meta,
			int runType) {
		meta.setType(DomHelper.readAttr(element, MetaConstants.COMMON_TYPE, "DataSplit"));
		meta.setTargetObjectKey(DomHelper.readAttr(element, MetaConstants.BATCHPERSIST_TARGETOBJECTKEY, ""));
		meta.setPrimaryTable(DomHelper.readAttr(element, MetaConstants.BATCHPERSIST_PRIMARYTABLE, ""));
	}

	@Override
	public void save(Document document, Element element, MetaBatchPersist meta,
			int runType) {
		DomHelper.writeAttr(element, MetaConstants.COMMON_TYPE, meta.getType(), "DataSplit");
		DomHelper.writeAttr(element, MetaConstants.BATCHPERSIST_TARGETOBJECTKEY, meta.getTargetObjectKey(), "");
		DomHelper.writeAttr(element, MetaConstants.BATCHPERSIST_PRIMARYTABLE, meta.getPrimaryTable(), "");
	}

}
