package com.bokesoft.yes.meta.persist.dom.custom;

import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

import com.bokesoft.yes.meta.persist.dom.solution.BaseMetaScanLoad;
import com.bokesoft.yigo.common.def.AppRunType;
import com.bokesoft.yigo.meta.base.IMetaResolver;
import com.bokesoft.yigo.meta.base.KeyPairMetaObject;
import com.bokesoft.yigo.meta.custom.IMetaCustomObjectBuilder;
import com.bokesoft.yigo.meta.datamap.MetaDataMapProfile;
import com.bokesoft.yigo.meta.solution.MetaProject;

public class MetaCustomObjectScanLoad extends BaseMetaScanLoad {
	private int runType = AppRunType.App;
	private List<KeyPairMetaObject> customList;
	private List<KeyPairMetaObject> fileList;
	private String impl = null;
	
	public MetaCustomObjectScanLoad(List<KeyPairMetaObject> customList, IMetaResolver resolver, MetaProject metaProject, Object context, String impl, int runType) {
		super(resolver, metaProject, "Custom", context);
		this.customList = customList;
		this.fileList = new CopyOnWriteArrayList<KeyPairMetaObject>();
		this.runType = runType;
		this.impl = impl;
	}
	
	protected void doFind(Object parent, String parentPath, String filePath, String fileName, MetaDataMapProfile profile) {
		
	}
		
	protected void postLoad() throws Throwable {
		super.postLoad();
		merge();
	}
	
	@Override
	public void loadMetaData(Object parent, String parentPath, String filePath, String fileName) throws Exception {
		Class<?> clzz = Class.forName(impl);
		@SuppressWarnings("deprecation")
		IMetaCustomObjectBuilder builder = (IMetaCustomObjectBuilder) clzz.newInstance();
		InputStream in = resolver.read(filePath, 0);
		KeyPairMetaObject meta = builder.build(in, parent, metaProject, parentPath, filePath, fileName);
		fileList.add(meta);
	}

	public int getRunType() {
		return runType;
	}

	private void merge() {
		if(fileList.isEmpty()) {
			return;
		}
		
		try {
			this.customList.addAll(fileList);
			Collections.sort(this.customList);
		}finally {
			fileList.clear();
		}
	}
	
	public List<KeyPairMetaObject> getMetaCustomObjectList() {
		merge();
		return this.customList;
	}
	
}
