package com.bokesoft.yes.meta.persist.dom.commondef;

import java.util.Iterator;
import java.util.concurrent.CopyOnWriteArrayList;

import com.bokesoft.yes.meta.persist.dom.DomMetaConstants;
import com.bokesoft.yes.meta.persist.dom.solution.BaseMetaScanLoad;
import com.bokesoft.yigo.common.def.AppRunType;
import com.bokesoft.yigo.meta.base.IMetaResolver;
import com.bokesoft.yigo.meta.datamigration.MetaDataMigrationProfile;
import com.bokesoft.yigo.meta.domain.MetaDomain;
import com.bokesoft.yigo.meta.domain.MetaDomainCollection;
import com.bokesoft.yigo.meta.domain.MetaDomainDef;
import com.bokesoft.yigo.meta.solution.MetaProject;

/**
 * 域目录扫描，最后返回MetaDomainDef
 */
public class MetaDomainFoldScanLoad extends BaseMetaScanLoad {
	private int runType = AppRunType.App;
	private MetaDomainDef domainDef;
	private CopyOnWriteArrayList<MetaDomainDef> list;
	public MetaDomainFoldScanLoad(IMetaResolver resolver, MetaProject metaProject, Object context, int runType) {
		super(resolver, metaProject, DomMetaConstants.DOMAIN_FOLD, context);
		this.domainDef = new MetaDomainDef();
		this.runType = runType;
		list = new CopyOnWriteArrayList<MetaDomainDef>();
	}
	
	protected void doFind(Object parent, String parentPath, String filePath, String fileName, MetaDataMigrationProfile profile) {
		
	}
	
	private void merge() {
		if(list.isEmpty()){
			return;
		}
		
		try {
			for(MetaDomainDef meta: list) {
				this.domainDef.toMerge(meta);
			}
			
			MetaDomainCollection domainCollection = this.domainDef.getDomainCollection();
			if(domainCollection == null || domainCollection.isEmpty()) {
				return;
			}
			
			Iterator<MetaDomain> it = domainCollection.iterator();
			MetaDomain meta;
			while(it.hasNext()) {
				meta = it.next();
				meta.setProject(metaProject);
			}
		}finally {
			list.clear();
		}
	}
	@Override
	public void loadMetaData(Object parent, String parentPath, String filePath, String fileName) throws Exception {
		MetaDomainDefLoad load = new MetaDomainDefLoad(AppRunType.App);
		load.load(resolver, filePath);
		MetaDomainDef temp = (MetaDomainDef) load.getRootMetaObject();
		if (temp != null) {
			MetaDomainCollection domainCollection = temp.getDomainCollection();
			if(domainCollection == null || domainCollection.isEmpty()) {
				return;
			}
			
			list.add(temp);
		}
	}

	public int getRunType() {
		return runType;
	}
	
	public MetaDomainDef getMetaDomainDef() {
		merge();
		return this.domainDef;
	}
}
