package com.bokesoft.yes.meta.persist.dom.common;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.BaseDomAction;
import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.common.MetaMidProcess;

public class MetaMidProcessAction extends BaseDomAction<MetaMidProcess> {
	@Override
	public void load(Document document, Element element, MetaMidProcess meta, int runType) {
		meta.setDescription(DomHelper.readAttr(element, MetaConstants.COMMON_DESCRIPTION, ""));
		meta.setImpl(DomHelper.readAttr(element, MetaConstants.PROCESS_IMPL, ""));
		meta.setTime(DomHelper.readAttr(element, MetaConstants.PROCESS_TIME, "Post"));
	}

	@Override
	public void save(Document document, Element element, MetaMidProcess meta, int runType) {
		DomHelper.writeAttr(element, MetaConstants.COMMON_DESCRIPTION, meta.getDescription(), "");
		DomHelper.writeAttr(element, MetaConstants.PROCESS_IMPL, meta.getImpl(), "");
		DomHelper.writeAttr(element, MetaConstants.PROCESS_TIME, meta.getTime(), "Post");
	}
}
