package com.bokesoft.yes.meta.persist.dom.common;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.BaseDomAction;
import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.common.MetaCustomDataItem;

public class MetaCustomDataItemAction extends BaseDomAction<MetaCustomDataItem> {

	@Override
	public void load(Document document, Element element, MetaCustomDataItem meta, int runType) {
		meta.setKey(DomHelper.readAttr(element, MetaConstants.COMMON_KEY, ""));
		meta.setValue(DomHelper.readAttr(element, MetaConstants.COMMON_VALUE, ""));
	}

	@Override
	public void save(Document document, Element element, MetaCustomDataItem meta, int runType) {
		DomHelper.writeAttr(element, MetaConstants.COMMON_KEY, meta.getKey(), "");
		DomHelper.writeAttr(element, MetaConstants.COMMON_VALUE, meta.getValue(), "");
	}

}
