package com.bokesoft.yes.meta.persist.dom.common;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.BaseDomAction;
import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.def.ScriptRunType;
import com.bokesoft.yigo.common.def.ScriptType;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.common.MetaBaseScript;

public class MetaBaseScriptExtAction<T extends MetaBaseScript> extends BaseDomAction<T> {
	@Override
	public void load(Document document, Element element, T meta, int runType) {
		meta.setKey(DomHelper.readAttr(element, MetaConstants.COMMON_KEY, ""));
		meta.setTagName(element.getTagName().intern());
		if( element.hasAttribute(MetaConstants.COMMON_TYPE) ) {
			meta.setType(ScriptType.parse(DomHelper.readAttr(element, MetaConstants.COMMON_TYPE, ScriptType.STR_Formula)));
		}else {
			meta.setType(-1);
		}
		if( element.hasAttribute(MetaConstants.SCRIPT_RUNTYPE) ) {
			meta.setRunType(ScriptRunType.parse(DomHelper.readAttr(element, MetaConstants.SCRIPT_RUNTYPE, ScriptRunType.STR_Undefined)));
		} else {
			meta.setRunType(-1);
		}
		if (element.getChildNodes().getLength() > 0) {
			meta.setContent(DomHelper.readCDATAContent(element).trim().intern());
		} else {
			meta.setContent(null);
		}
	}
	@Override
	public void save(Document document, Element element, T meta, int runType) {
	}

}
