package com.bokesoft.yes.meta.persist.dom.bpm.action.node;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.bpm.BPMConstants;
import com.bokesoft.yigo.meta.bpm.process.node.MetaState;

public class MetaStateDomAction extends MetaNodeAction<MetaState> {

	@Override
	public void load(Document doc, Element node, MetaState meta, int runType) {
		super.load(doc, node, meta, runType);
		meta.setStatus(DomHelper.readAttr(node, BPMConstants.NODE_STATUS, ""));
		meta.setCreateTrigger(DomHelper.readAttr(node, BPMConstants.NODE_CREATE_TRIGGER, ""));
		meta.setFinishTrigger(DomHelper.readAttr(node, BPMConstants.NODE_FINISH_TRIGGER, ""));
		meta.setFieldKey(DomHelper.readAttr(node, BPMConstants.NODE_FIELD_KEY, ""));
		meta.setFieldValue(DomHelper.readAttr(node, BPMConstants.NODE_FIELD_VALUE, ""));
	}

	@Override
	public void save(Document doc, Element node, MetaState meta, int runType) {
		super.save(doc, node, meta, runType);
		DomHelper.writeAttr(node, BPMConstants.NODE_STATUS, meta.getStatus(), "");
		DomHelper.writeAttr(node, BPMConstants.NODE_CREATE_TRIGGER, meta.getCreateTrigger(), "");
		DomHelper.writeAttr(node, BPMConstants.NODE_FINISH_TRIGGER, meta.getFinishTrigger(), "");
		DomHelper.writeAttr(node, BPMConstants.NODE_FIELD_KEY, meta.getFieldKey(), "");
		DomHelper.writeAttr(node, BPMConstants.NODE_FIELD_VALUE, meta.getFieldValue(), "");
	}

}
