package com.bokesoft.yes.meta.persist.dom.bpm.action.node;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.bpm.BPMConstants;
import com.bokesoft.yigo.meta.bpm.process.node.MetaInline;

public class MetaInlineAction extends MetaNodeAction<MetaInline> {

	@Override
	public void load(Document doc, Element node, MetaInline meta, int runType) {
		super.load(doc, node, meta, runType);
		meta.setInlineProcessKey(DomHelper.readAttr(node, BPMConstants.NODE_INLINE_PROCESS_KEY, ""));
		meta.setProcessKeyFormula(DomHelper.readAttr(node, BPMConstants.NODE_INLINE_PROCESS_KEY_FORMULA, ""));
	}

	@Override
	public void save(Document doc, Element node, MetaInline meta, int runType) {
		super.save(doc, node, meta, runType);
		DomHelper.writeAttr(node, BPMConstants.NODE_INLINE_PROCESS_KEY, meta.getInlineProcessKey(), "");
		DomHelper.writeAttr(node, BPMConstants.NODE_INLINE_PROCESS_KEY_FORMULA, meta.getProcessKeyFormula(), "");
	}

}
