package com.bokesoft.yes.meta.persist.dom.bpm.action.node;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.bpm.BPMConstants;
import com.bokesoft.yigo.meta.bpm.process.node.MetaGateWay;

public class MetaGateWayAction extends MetaNodeAction<MetaGateWay> {

	@Override
	public void load(Document doc, Element node, MetaGateWay meta, int runType) {
		super.load(doc, node, meta, runType);
		meta.setCondition(DomHelper.readAttr(node, BPMConstants.ELEMENT_CONDITION, ""));
	}
	
	@Override
	public void save(Document doc, Element node, MetaGateWay meta, int runType) {
		super.save(doc, node, meta, runType);
		DomHelper.writeAttr(node, BPMConstants.ELEMENT_CONDITION, meta.getCondition(), "");
	}
	
}
