package com.bokesoft.yes.meta.persist.dom.bpm.action.data;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.BaseDomAction;
import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.def.DataType;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.bpm.BPMConstants;
import com.bokesoft.yigo.meta.bpm.process.data.MetaDataItem;

public class MetaDataItemAction extends BaseDomAction<MetaDataItem> {

	@Override
	public void load(Document document, Element element, MetaDataItem meta, int runType) {
		meta.setKey(DomHelper.readAttr(element, MetaConstants.COMMON_KEY, ""));
		meta.setDataType(DataType.parse(DomHelper.readAttr(element, MetaConstants.COLUMN_DATATYPE, "")));
		meta.setCache(DomHelper.readAttr(element, BPMConstants.DATA_ITEM_CACHE, false));
		meta.setFromDefault(DomHelper.readAttr(element, BPMConstants.DATA_ITEM_DEFAULT, false));
	}

	@Override
	public void save(Document document, Element element, MetaDataItem meta, int runType) {
		DomHelper.writeAttr(element, MetaConstants.COMMON_KEY, meta.getKey(), "");
		DomHelper.writeAttr(element, MetaConstants.COLUMN_DATATYPE, DataType.toString(meta.getDataType()), "");
		DomHelper.writeAttr(element, BPMConstants.DATA_ITEM_CACHE, meta.isCache(), false);
		DomHelper.writeAttr(element, BPMConstants.DATA_ITEM_DEFAULT, meta.isFromDefault(), false);
	}

}
