package com.bokesoft.yes.meta.persist.dom.bpm.action.collection.item;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.BaseDomAction;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.bpm.BPMConstants;
import com.bokesoft.yigo.meta.bpm.process.attribute.MetaTableTrigger;

public class MetaTableTriggerAction extends BaseDomAction<MetaTableTrigger> {

	@Override
	public void load(Document document, Element node, MetaTableTrigger meta, int runType) {
		meta.setKey(DomHelper.readAttr(node, BPMConstants.COMMON_KEY, ""));
		meta.setColumnListStr(DomHelper.readAttr(node, BPMConstants.COLUMN_LIST_STR, ""));
	}

	@Override
	public void save(Document document, Element node, MetaTableTrigger meta, int runType) {
		DomHelper.writeAttr(node, BPMConstants.COMMON_KEY, meta.getKey(), "");
		DomHelper.writeAttr(node, BPMConstants.COLUMN_LIST_STR, meta.getColumnListStr(), "");
	}

}
