package com.bokesoft.yes.meta.persist.dom.bpm.action.collection.item;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.BaseDomAction;
import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.bpm.process.attribute.participator.MetaRelationNode;
import com.bokesoft.yigo.meta.relation.MetaRelationConstants;

public class MetaRelationNodeAction extends BaseDomAction<MetaRelationNode> {

	@Override
	public void load(Document document, Element element, MetaRelationNode meta, int runType) {
		// TODO Auto-generated method stub
		meta.setCaption(DomHelper.readAttr(element, MetaConstants.COMMON_CAPTION, ""));
		meta.setDataobjectkey(DomHelper.readAttr(element, MetaRelationConstants.RELATION_DATAOBJECTKEY, ""));
		meta.setRelationkey(DomHelper.readAttr(element, MetaRelationConstants.RELATION_RELATIONKEY, ""));
		meta.setId(new Integer(DomHelper.readAttr(element, MetaRelationConstants.RELATION_ID, 1)));
		meta.setX(new Integer(DomHelper.readAttr(element, MetaRelationConstants.RELATION_X, -1)));
		meta.setY(new Integer(DomHelper.readAttr(element, MetaRelationConstants.RELATION_Y, -1)));
		
	}

	@Override
	public void save(Document document, Element element, MetaRelationNode meta, int runType) {
		// TODO Auto-generated method stub
		DomHelper.writeAttr(element, MetaConstants.COMMON_CAPTION, meta.getCaption(), "");
		DomHelper.writeAttr(element, MetaRelationConstants.RELATION_DATAOBJECTKEY, meta.getDataobjectkey(), "");
		DomHelper.writeAttr(element, MetaRelationConstants.RELATION_RELATIONKEY, meta.getRelationkey(), "");
		DomHelper.writeAttr(element, MetaRelationConstants.RELATION_ID, meta.getId(), -1);
		DomHelper.writeAttr(element, MetaRelationConstants.RELATION_X, meta.getX(), -1);
		DomHelper.writeAttr(element, MetaRelationConstants.RELATION_Y, meta.getY(), -1);
		
	}

}
