package com.bokesoft.yes.meta.persist.dom.bpm.action.collection;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.BaseDomAction;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.bpm.BPMConstants;
import com.bokesoft.yigo.meta.bpm.process.attribute.LineStyle;
import com.bokesoft.yigo.meta.bpm.process.attribute.MetaTransitionGraphic;

public class MetaTransitionGraphicAction extends
		BaseDomAction<MetaTransitionGraphic> {

	@Override
	public void load(Document doc, Element node, MetaTransitionGraphic meta, int runType) {
		meta.setLineStyle(LineStyle.parseLineStyle(DomHelper.readAttr(
				node, BPMConstants.GRAPHIC_LINE_STYLE,
				LineStyle.STR_STEAIGHT_LINE)));
		meta.setStyle(DomHelper.readAttr(node, BPMConstants.ELEMENT_STYLE, ""));
	}

	@Override
	public void save(Document doc, Element node, MetaTransitionGraphic meta, int runType) {
		DomHelper.writeAttr(node, BPMConstants.GRAPHIC_LINE_STYLE,
				LineStyle.formatLineStyleString(meta.getLineStyle()),
				LineStyle.STR_STEAIGHT_LINE);
		DomHelper.writeAttr(node, BPMConstants.ELEMENT_STYLE, meta.getStyle(), "");
	}

}
