package com.bokesoft.yes.meta.persist.dom.bpm.action;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.BaseDomAction;
import com.bokesoft.yigo.common.def.BPMLockType;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.bpm.BPMConstants;
import com.bokesoft.yigo.meta.bpm.process.MetaProcess;

public class MetaProcessAction extends BaseDomAction<MetaProcess> {

	@Override
	public void load(Document doc, Element node, MetaProcess meta, int runType) {
		meta.setCaption(DomHelper.readAttr(node, BPMConstants.COMMON_CAPTION, ""));
		meta.setIdSeed(DomHelper.readAttr(node, BPMConstants.COMMON_IDSEED, 0));
		meta.setKey(DomHelper.readAttr(node, BPMConstants.COMMON_KEY, ""));
		meta.setVersion(DomHelper.readAttr(node, BPMConstants.COMMON_VERSION, 1));
		meta.setFormKey(DomHelper.readAttr(node, BPMConstants.FORM_KEY, ""));
		meta.setKillInstanceTrigger(DomHelper.readAttr(node, BPMConstants.KILL_INSTANCE_TRIGGER, ""));
		meta.setTemplateKey(DomHelper.readAttr(node, BPMConstants.NODE_TEMPLATEKEY, ""));
		if (DomHelper.readAttr(node, BPMConstants.IGNORE_FORM_STATE, "") != null &&DomHelper.readAttr(node, BPMConstants.IGNORE_FORM_STATE, "").length()>0) {
			meta.setIgnoreFormState(new Boolean(DomHelper.readAttr(node, BPMConstants.IGNORE_FORM_STATE, "")));
		}
		meta.setQueryRetreatWorkitem(DomHelper.readAttr(node, BPMConstants.QUERY_RETREAT_WORKITEM, true));
		meta.setLockWorkitem(BPMLockType.parse(DomHelper.readAttr(node, BPMConstants.LOCK_WORKITEM, BPMLockType.STR_FALSE)));
		meta.setWorkitemCreateTrigger(DomHelper.readAttr(node, BPMConstants.WORKITEM_CREATE_TRIGGER, ""));
		meta.setForbidOperateMark(DomHelper.readAttr(node, BPMConstants.FORBID_OPERATE_MARK, ""));
	}

	@Override
	public void save(Document doc, Element node, MetaProcess meta, int runType) {
		DomHelper.writeAttr(node, BPMConstants.COMMON_CAPTION, meta.getCaption(), "");
		DomHelper.writeAttr(node, BPMConstants.COMMON_IDSEED, meta.getIdSeed(), 0);
		DomHelper.writeAttr(node, BPMConstants.COMMON_KEY, meta.getKey(), "");
		DomHelper.writeAttr(node, BPMConstants.COMMON_VERSION, meta.getVersion(), 1);
		DomHelper.writeAttr(node, BPMConstants.FORM_KEY, meta.getFormKey(), "");
		DomHelper.writeAttr(node, BPMConstants.KILL_INSTANCE_TRIGGER, meta.getKillInstanceTrigger(), "");
		DomHelper.writeAttr(node, BPMConstants.NODE_TEMPLATEKEY, meta.getTemplateKey(), "");
		if (meta.getIgnoreFormState() != null) {
			DomHelper.writeAttr(node, BPMConstants.IGNORE_FORM_STATE, meta.getIgnoreFormState().toString(), "");
		} else {
			DomHelper.writeAttr(node, BPMConstants.IGNORE_FORM_STATE, "", "");
		}
		DomHelper.writeAttr(node, BPMConstants.QUERY_RETREAT_WORKITEM, meta.getQueryRetreatWorkitem(), true);
		DomHelper.writeAttr(node, BPMConstants.LOCK_WORKITEM, BPMLockType.toString(meta.getLockWorkitem()), BPMLockType.STR_FALSE);
		DomHelper.writeAttr(node, BPMConstants.WORKITEM_CREATE_TRIGGER, meta.getWorkitemCreateTrigger(), "");
		DomHelper.writeAttr(node, BPMConstants.FORBID_OPERATE_MARK, meta.getForbidOperateMark(), "");
	}

}
