package com.bokesoft.yes.meta.persist.dom.bpm.action;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.BaseDomAction;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.bpm.BPMConstants;
import com.bokesoft.yigo.meta.bpm.process.event.MetaEventItem;

public class MetaEventItemAction extends BaseDomAction<MetaEventItem> {

	@Override
	public void load(Document document, Element element, MetaEventItem meta, int runType) {
		meta.setKey(DomHelper.readAttr(element, BPMConstants.COMMON_KEY, ""));
		meta.setAction(DomHelper.readAttr(element, BPMConstants.NODE_ACTION, ""));
	}

	@Override
	public void save(Document document, Element element, MetaEventItem meta, int runType) {
		DomHelper.writeAttr(element, BPMConstants.COMMON_KEY, meta.getKey(), "");
		DomHelper.writeAttr(element, BPMConstants.NODE_ACTION, meta.getAction(), "");
	}

}
