package com.bokesoft.yes.meta.persist.dom.bpm.action;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.BaseDomAction;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.bpm.AbstractBPMElement;
import com.bokesoft.yigo.meta.bpm.BPMConstants;

public class MetaBPMElementAction<T extends AbstractBPMElement> extends BaseDomAction<T> {

	@Override
	public void load(Document doc, Element node, T meta, int runType) {
		meta.setID(DomHelper.readAttr(node, BPMConstants.COMMON_ID, -1));
		meta.setKey(DomHelper.readAttr(node, BPMConstants.COMMON_KEY, ""));
		meta.setCaption(DomHelper.readAttr(node, BPMConstants.COMMON_CAPTION, ""));
	}

	@Override
	public void save(Document doc, Element node, T meta, int runType) {
		DomHelper.writeAttr(node, BPMConstants.COMMON_ID, meta.getID(), -1);
		DomHelper.writeAttr(node, BPMConstants.COMMON_KEY, meta.getKey(), "");
		DomHelper.writeAttr(node, BPMConstants.COMMON_CAPTION, meta.getCaption(), "");
	}

}
