package com.bokesoft.yes.meta.persist.dom.bpm;

import com.bokesoft.yes.meta.persist.dom.MetaActionMap;
import com.bokesoft.yes.meta.persist.dom.bpm.action.MetaBPMAction;
import com.bokesoft.yes.meta.persist.dom.bpm.action.MetaBPMDeployInfoAction;
import com.bokesoft.yes.meta.persist.dom.bpm.action.MetaProcessMapAction;
import com.bokesoft.yes.meta.persist.dom.bpm.action.collection.MetaBPMDeployInfoCollectionAction;
import com.bokesoft.yes.meta.persist.dom.bpm.action.collection.MetaWorkflowMapCollectionAction;
import com.bokesoft.yes.meta.persist.dom.bpm.action.perm.MetaEnablePermAction;
import com.bokesoft.yes.meta.persist.dom.bpm.action.perm.MetaEnablePermItemAction;
import com.bokesoft.yes.meta.persist.dom.bpm.action.perm.MetaOptPermAction;
import com.bokesoft.yes.meta.persist.dom.bpm.action.perm.MetaOptPermItemAction;
import com.bokesoft.yes.meta.persist.dom.bpm.action.perm.MetaPermAction;
import com.bokesoft.yes.meta.persist.dom.bpm.action.perm.MetaVisiblePermAction;
import com.bokesoft.yes.meta.persist.dom.bpm.action.perm.MetaVisiblePermItemAction;
import com.bokesoft.yigo.meta.bpm.process.perm.MetaEnablePerm;
import com.bokesoft.yigo.meta.bpm.process.perm.MetaEnablePermItem;
import com.bokesoft.yigo.meta.bpm.process.perm.MetaOptPerm;
import com.bokesoft.yigo.meta.bpm.process.perm.MetaOptPermItem;
import com.bokesoft.yigo.meta.bpm.process.perm.MetaPerm;
import com.bokesoft.yigo.meta.bpm.process.perm.MetaVisiblePerm;
import com.bokesoft.yigo.meta.bpm.process.perm.MetaVisiblePermItem;
import com.bokesoft.yigo.meta.bpm.total.MetaBPM;
import com.bokesoft.yigo.meta.bpm.total.MetaProcessDeployInfo;
import com.bokesoft.yigo.meta.bpm.total.MetaProcessDeployInfoCollection;
import com.bokesoft.yigo.meta.bpm.total.MetaProcessMap;
import com.bokesoft.yigo.meta.bpm.total.MetaProcessMapCollection;

public class MetaBPMActionMap extends MetaActionMap {

	@Override
	protected Object[][] getActionLookupTable() {
		return new Object[][] {
				{ MetaBPM.TAG_NAME, new MetaBPMAction() },
				{ MetaProcessDeployInfoCollection.TAG_NAME,
						new MetaBPMDeployInfoCollectionAction() },
				{ MetaProcessMapCollection.TAG_NAME,
						new MetaWorkflowMapCollectionAction() },
				{ MetaProcessDeployInfo.TAG_NAME, new MetaBPMDeployInfoAction() },
				{ MetaProcessMap.TAG_NAME, new MetaProcessMapAction() },
				
				{ MetaPerm.TAG_NAME, new MetaPermAction() },
				{ MetaOptPerm.TAG_NAME, new MetaOptPermAction() },
				{ MetaOptPermItem.TAG_NAME, new MetaOptPermItemAction() },
				{ MetaEnablePerm.TAG_NAME, new MetaEnablePermAction() },
				{ MetaEnablePermItem.TAG_NAME, new MetaEnablePermItemAction() },
				{ MetaVisiblePerm.TAG_NAME, new MetaVisiblePermAction() },
				{ MetaVisiblePermItem.TAG_NAME, new MetaVisiblePermItemAction() }
			};
	}

	/** BPM文件事件映射的单体实例 */
	private static MetaBPMActionMap instance = null;

	/**
	 * 取得BPM文件事件映射的单体实例
	 * 
	 * @return BPM文件事件映射的单体实例
	 */
	public static MetaBPMActionMap getInstance() {
		if (instance == null) {
			instance = new MetaBPMActionMap();
		}
		return instance;
	}

	@Override
	protected Object[][] getHostActionLookupTable() {
		return null;
	}
}
