package com.bokesoft.yes.meta.persist.dom.archive;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.BaseDomAction;
import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.def.ArchiveConditionType;
import com.bokesoft.yigo.common.def.ArchiveTimeType;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.archive.MetaArchive;
import com.bokesoft.yigo.meta.archive.MetaField;

public class MetaFieldAction extends BaseDomAction<MetaField>{

	@Override
	public void load(Document document, Element element, MetaField meta, int runType) {
		meta.setKey(DomHelper.readAttr(element, MetaConstants.COMMON_KEY, ""));
		String strType = DomHelper.readAttr(element, MetaArchiveConstants.CONDITION_TYPE, "");
		meta.setConditionType(ArchiveConditionType.parse(strType));
		String dateType=DomHelper.readAttr(element, MetaArchiveConstants.DATE_TYPE, "");
		meta.setDateType(ArchiveTimeType.parse(dateType));
	}

	@Override
	public void save(Document document, Element element, MetaField meta, int runType) {
		DomHelper.writeAttr(element, MetaConstants.COMMON_KEY, meta.getKey(), "");
		String strType = ArchiveConditionType.toString(meta.getConditionType());
		DomHelper.writeAttr(element, MetaArchiveConstants.CONDITION_TYPE, strType, "");
		String dateType = ArchiveTimeType.toString(meta.getDateType());
		DomHelper.writeAttr(element, MetaArchiveConstants.DATE_TYPE, dateType, "");
	}

}
