/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yigo.meta.form;

import com.bokesoft.yes.common.struct.StringHashMap;
import com.bokesoft.yigo.meta.form.IPropertiesElement;
import com.bokesoft.yigo.meta.form.component.MetaComponent;
import com.bokesoft.yigo.meta.form.component.control.editview.MetaEditViewColumn;
import com.bokesoft.yigo.meta.form.component.control.listview.MetaListViewColumn;
import com.bokesoft.yigo.meta.form.component.grid.MetaGridCell;
import java.io.Serializable;
import java.util.HashMap;

public class MetaFormBindingMap
implements Serializable {
    private static final long serialVersionUID = 1L;
    private HashMap<String, HashMap<String, MetaComponent>> comMap = StringHashMap.newInstance();
    private HashMap<String, HashMap<String, MetaGridCell>> cellMap = StringHashMap.newInstance();
    private HashMap<String, HashMap<String, MetaListViewColumn>> lvcMap = StringHashMap.newInstance();
    private HashMap<String, HashMap<String, MetaEditViewColumn>> evcMap = StringHashMap.newInstance();

    public void buildBinding(String tableKey, String columnKey, IPropertiesElement ele) {
        switch (ele.getTagName()) {
            case "GridCell": {
                this.buildCellBinding(tableKey, columnKey, (MetaGridCell)ele);
                break;
            }
            case "ListViewColumn": {
                this.buildLVColumnBinding(tableKey, columnKey, (MetaListViewColumn)ele);
                break;
            }
            case "EditViewColumn": {
                this.buildEVColumnBinding(tableKey, columnKey, (MetaEditViewColumn)ele);
                break;
            }
            default: {
                this.buildComponentBinding(tableKey, columnKey, (MetaComponent)ele);
            }
        }
    }

    public void clear() {
        this.comMap.clear();
        this.cellMap.clear();
        this.lvcMap.clear();
        this.evcMap.clear();
    }

    private void buildComponentBinding(String tableKey, String columnKey, MetaComponent component) {
        StringHashMap map = this.comMap.get(tableKey);
        if (map == null) {
            map = StringHashMap.newInstance();
            this.comMap.put(tableKey, (HashMap<String, MetaComponent>)map);
        }
        map.put(columnKey, component);
    }

    private void buildCellBinding(String tableKey, String columnKey, MetaGridCell metaCell) {
        StringHashMap map = this.cellMap.get(tableKey);
        if (map == null) {
            map = StringHashMap.newInstance();
            this.cellMap.put(tableKey, (HashMap<String, MetaGridCell>)map);
        }
        map.put(columnKey, metaCell);
    }

    private void buildLVColumnBinding(String tableKey, String columnKey, MetaListViewColumn metaColumn) {
        StringHashMap map = this.lvcMap.get(tableKey);
        if (map == null) {
            map = StringHashMap.newInstance();
            this.lvcMap.put(tableKey, (HashMap<String, MetaListViewColumn>)map);
        }
        map.put(columnKey, metaColumn);
    }

    private void buildEVColumnBinding(String tableKey, String columnKey, MetaEditViewColumn metaColumn) {
        StringHashMap map = this.evcMap.get(tableKey);
        if (map == null) {
            map = StringHashMap.newInstance();
            this.evcMap.put(tableKey, (HashMap<String, MetaEditViewColumn>)map);
        }
        map.put(columnKey, metaColumn);
    }

    public MetaGridCell getCellByDataBinding(String tableKey, String columnKey) {
        HashMap<String, MetaGridCell> map = this.cellMap.get(tableKey);
        return map == null ? null : map.get(columnKey);
    }

    public MetaComponent getComponentByDataBinding(String tableKey, String columnKey) {
        HashMap<String, MetaComponent> map = this.comMap.get(tableKey);
        return map == null ? null : map.get(columnKey);
    }

    public MetaListViewColumn getLvColumnByDataBinding(String tableKey, String columnKey) {
        HashMap<String, MetaListViewColumn> map = this.lvcMap.get(tableKey);
        return map == null ? null : map.get(columnKey);
    }

    public MetaEditViewColumn getEvColumnByDataBinding(String tableKey, String columnKey) {
        HashMap<String, MetaEditViewColumn> map = this.evcMap.get(tableKey);
        return map == null ? null : map.get(columnKey);
    }
}

