/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yigo.meta.factory;

import com.bokesoft.yigo.meta.base.IMetaResolver;
import com.bokesoft.yigo.meta.strings.MetaStringTable;
import com.bokesoft.yigo.meta.strings.MetaStringTableProfile;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;

public class GlobalI18N {
    private Map<String, MetaStringTable> formStringsMap = new ConcurrentHashMap<String, MetaStringTable>();
    private Map<String, List<MetaStringTableProfile>> formProfileMap = new ConcurrentHashMap<String, List<MetaStringTableProfile>>();
    private Map<String, MetaStringTable> processStringsMap = new ConcurrentHashMap<String, MetaStringTable>();
    private Map<String, List<MetaStringTableProfile>> processProfileMap = new ConcurrentHashMap<String, List<MetaStringTableProfile>>();
    private Map<String, MetaStringTable> dataObjectStringsMap = new ConcurrentHashMap<String, MetaStringTable>();
    private Map<String, List<MetaStringTableProfile>> dataObjectProfileMap = new ConcurrentHashMap<String, List<MetaStringTableProfile>>();
    private List<MetaStringTableProfile> solutionMultiLangList = new CopyOnWriteArrayList<MetaStringTableProfile>();
    private MetaStringTable strings = null;
    private List<MetaStringTableProfile> solutionMapMultiLangList = new CopyOnWriteArrayList<MetaStringTableProfile>();
    private MetaStringTable mapStrings = null;
    private List<MetaStringTableProfile> solutionMigrationMultiLangList = new CopyOnWriteArrayList<MetaStringTableProfile>();
    private MetaStringTable migrationStrings = null;

    public void addSolutionProfile(MetaStringTableProfile profile) {
        this.solutionMultiLangList.add(profile);
    }

    public void addSolutionMapProfile(MetaStringTableProfile profile) {
        this.solutionMapMultiLangList.add(profile);
    }

    public void addSolutionMigrationProfile(MetaStringTableProfile profile) {
        this.solutionMigrationMultiLangList.add(profile);
    }

    public void clearSolutionI18N() {
        this.solutionMultiLangList.clear();
        this.solutionMapMultiLangList.clear();
        this.solutionMigrationMultiLangList.clear();
        this.strings = null;
        this.mapStrings = null;
        this.migrationStrings = null;
    }

    public void loadAll() throws Throwable {
        this.getSolutionStrings();
        this.getSolutionMapStrings();
        this.getSolutionMigrationStrings();
        this.loadAllBPMString();
        this.loadAllDataObjectStrings();
    }

    public MetaStringTable getSolutionStrings() throws Throwable {
        if (this.strings == null) {
            this.strings = this.__load__(this.solutionMultiLangList, new MetaStringTable());
        }
        return this.strings;
    }

    public void setSolutionStrings(MetaStringTable strings) throws Throwable {
        this.strings = strings;
    }

    public MetaStringTable getSolutionStrings(String lang) throws Throwable {
        if (this.strings == null) {
            this.strings = this.__load__(this.solutionMultiLangList, new MetaStringTable(), lang);
        }
        return this.strings;
    }

    public MetaStringTable getSolutionMapStrings() throws Throwable {
        if (this.mapStrings == null) {
            this.mapStrings = this.__load__(this.solutionMultiLangList, new MetaStringTable());
        }
        return this.mapStrings;
    }

    public MetaStringTable getSolutionMigrationStrings() throws Throwable {
        if (this.migrationStrings == null) {
            this.migrationStrings = this.__load__(this.solutionMultiLangList, new MetaStringTable());
        }
        return this.migrationStrings;
    }

    public void addFormProfile(String formKey, MetaStringTableProfile profile) {
        List<MetaStringTableProfile> list = this.formProfileMap.get(formKey);
        if (list == null) {
            list = new CopyOnWriteArrayList<MetaStringTableProfile>();
            this.formProfileMap.put(formKey, list);
        }
        list.add(profile);
    }

    public MetaStringTable getFormStrings(String formKey) throws Throwable {
        MetaStringTable strings = this.formStringsMap.get(formKey);
        if (strings == null) {
            strings = this.loadFormStrings(formKey);
        }
        return strings;
    }

    public void addProcessProfile(String processKey, MetaStringTableProfile profile) {
        List<MetaStringTableProfile> list = this.processProfileMap.get(processKey);
        if (list == null) {
            list = new CopyOnWriteArrayList<MetaStringTableProfile>();
            this.processProfileMap.put(processKey, list);
        }
        list.add(profile);
    }

    public MetaStringTable getProcessStrings(String processKey) throws Throwable {
        MetaStringTable strings = this.processStringsMap.get(processKey);
        if (strings == null) {
            strings = this.loadProcessStrings(processKey);
        }
        return strings;
    }

    public void addDataObjectProfile(String dataObjectKey, MetaStringTableProfile profile) {
        List<MetaStringTableProfile> list = this.dataObjectProfileMap.get(dataObjectKey);
        if (list == null) {
            list = new CopyOnWriteArrayList<MetaStringTableProfile>();
            this.dataObjectProfileMap.put(dataObjectKey, list);
        }
        list.add(profile);
    }

    public MetaStringTable getDataObjectStrings(String dataObjectKey) throws Throwable {
        MetaStringTable strings = this.dataObjectStringsMap.get(dataObjectKey);
        if (strings == null) {
            strings = this.loadDataObjectStrings(dataObjectKey);
        }
        return strings;
    }

    public void loadAllBPMString() throws Throwable {
        this.processStringsMap.clear();
        Set<String> keySet = this.processProfileMap.keySet();
        for (String key : keySet) {
            List<MetaStringTableProfile> list = this.processProfileMap.get(key);
            MetaStringTable strings = this.__load__(list, new MetaStringTable());
            this.processStringsMap.put(key, strings);
        }
    }

    public void loadAllDataObjectStrings() throws Throwable {
        this.dataObjectStringsMap.clear();
        Set<String> keySet = this.dataObjectProfileMap.keySet();
        for (String key : keySet) {
            List<MetaStringTableProfile> list = this.dataObjectProfileMap.get(key);
            MetaStringTable strings = this.__load__(list, new MetaStringTable());
            this.dataObjectStringsMap.put(key, strings);
        }
    }

    private MetaStringTable loadFormStrings(String formKey) throws Throwable {
        MetaStringTable strings = new MetaStringTable();
        List<MetaStringTableProfile> list = this.formProfileMap.get(formKey);
        if (list != null) {
            this.formStringsMap.put(formKey, this.__load__(list, strings));
        }
        return strings;
    }

    private MetaStringTable loadProcessStrings(String processKey) throws Throwable {
        MetaStringTable strings = new MetaStringTable();
        List<MetaStringTableProfile> list = this.processProfileMap.get(processKey);
        if (list != null) {
            this.processStringsMap.put(processKey, this.__load__(list, strings));
        }
        return strings;
    }

    private MetaStringTable loadDataObjectStrings(String dataObjectKey) throws Throwable {
        MetaStringTable strings = new MetaStringTable();
        List<MetaStringTableProfile> list = this.dataObjectProfileMap.get(dataObjectKey);
        if (list != null) {
            this.dataObjectStringsMap.put(dataObjectKey, this.__load__(list, strings));
        }
        return strings;
    }

    private MetaStringTable __load__(List<MetaStringTableProfile> list, MetaStringTable strings) throws Throwable {
        for (MetaStringTableProfile profile : list) {
            String filePath = profile.getFilePath();
            String lang = profile.getLang();
            IMetaResolver resolver = profile.getResolver();
            InputStream in = resolver.read(filePath, 0);
            strings.load(lang, in);
            in.close();
        }
        return strings;
    }

    private MetaStringTable __load__(List<MetaStringTableProfile> list, MetaStringTable strings, String key) throws Throwable {
        for (MetaStringTableProfile profile : list) {
            String filePath = profile.getFilePath();
            String lang = profile.getLang();
            if (!lang.equals(key)) continue;
            IMetaResolver resolver = profile.getResolver();
            InputStream in = resolver.read(filePath, 0);
            strings.load(lang, in);
            in.close();
        }
        return strings;
    }
}

