/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.meta.persist.dom.xml.node;

import com.bokesoft.yes.common.util.StringUtil;
import com.bokesoft.yes.meta.persist.dom.xml.node.TagNode;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractNode {
    protected String text = null;
    private TagNode parent = null;
    private List<AbstractNode> preCommnetList = null;
    private List<AbstractNode> lastCommnetList = null;

    public AbstractNode(String text) {
        this.text = text;
    }

    public String getText() {
        return this.text;
    }

    public void appendLevelBlank(StringBuilder strBuilder, int level) {
        for (int i = 0; i < level; ++i) {
            strBuilder.append("    ");
        }
    }

    public abstract String toXml(int var1);

    public abstract AbstractNode clone();

    public abstract boolean hasPrimaryAttribute();

    public TagNode getParent() {
        return this.parent;
    }

    public void setParent(TagNode parent) {
        this.parent = parent;
    }

    public boolean isRoot() {
        return this.parent == null;
    }

    public void addPreComment(List<AbstractNode> comments) {
        if (comments == null) {
            return;
        }
        if (this.preCommnetList == null) {
            this.preCommnetList = new ArrayList<AbstractNode>();
        }
        for (AbstractNode node : comments) {
            this.preCommnetList.add(node);
        }
    }

    public void addLastComment(List<AbstractNode> comments) {
        if (comments == null) {
            return;
        }
        if (this.lastCommnetList == null) {
            this.lastCommnetList = new ArrayList<AbstractNode>();
        }
        for (AbstractNode node : comments) {
            this.lastCommnetList.add(node);
        }
    }

    public List<AbstractNode> getPreComment() {
        return this.preCommnetList;
    }

    public List<AbstractNode> getLastComment() {
        return this.lastCommnetList;
    }

    protected String convertSpecialChars(String str) {
        str = StringUtil.replaceAll((String)str, (String)"&", (String)"&amp;");
        str = StringUtil.replaceAll((String)str, (String)"<", (String)"&lt;");
        str = StringUtil.replaceAll((String)str, (String)">", (String)"&gt;");
        str = StringUtil.replaceAll((String)str, (String)"\"", (String)"&quot;");
        return str;
    }
}

