/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.meta.persist.dom.solution;

import com.bokesoft.yes.common.log.LogSvr;
import com.bokesoft.yigo.meta.base.IMetaResolver;
import com.bokesoft.yigo.meta.base.IMetaResourceFilter;
import com.bokesoft.yigo.meta.solution.MetaProject;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public abstract class BaseMetaScanLoad {
    protected IMetaResolver resolver = null;
    protected MetaProject metaProject = null;
    protected String resourcePath = null;
    protected String fileFilter = ".xml";
    protected Object context = null;
    protected IMetaResourceFilter filter = null;
    protected ExecutorService service = null;
    protected List<Future<?>> futureTaskList = null;

    public BaseMetaScanLoad(IMetaResolver resolver, MetaProject metaProject, String resourcePath, Object context) {
        this.resolver = resolver;
        this.metaProject = metaProject;
        this.resourcePath = resourcePath;
        this.context = context;
    }

    public void setFilter(IMetaResourceFilter filter) {
        this.filter = filter;
    }

    public IMetaResourceFilter getFilter() {
        return this.filter;
    }

    protected Object getRoot() {
        return null;
    }

    public void load() throws Throwable {
        try {
            this.preLoad();
            this.loadImpl();
            this.postLoad();
        }
        finally {
            if (this.service != null) {
                this.service.shutdown();
            }
        }
    }

    protected void preLoad() throws Throwable {
        this.service = Executors.newFixedThreadPool(5);
        this.futureTaskList = new ArrayList();
    }

    protected void loadImpl() throws Throwable {
        this.scan(this.getRoot(), this.resourcePath);
    }

    protected void postLoad() throws Throwable {
        if (this.futureTaskList == null) {
            return;
        }
        for (Future<?> task : this.futureTaskList) {
            task.get();
        }
    }

    protected Object loadFolder(Object parent, String path, String filePath) throws Throwable {
        return null;
    }

    protected void scan(Object parent, String filePath) throws Throwable {
        ArrayList<String> resourceList = new ArrayList<String>();
        ArrayList<String> nameList = new ArrayList<String>();
        ArrayList<Boolean> flagList = new ArrayList<Boolean>();
        this.resolver.listResource(filePath, this.fileFilter, resourceList, nameList, flagList);
        if (resourceList.size() > 0) {
            Iterator itPath = resourceList.iterator();
            Iterator itName = nameList.iterator();
            Iterator itFlag = flagList.iterator();
            while (itPath.hasNext()) {
                String fp;
                String path = (String)itPath.next();
                String name = (String)itName.next();
                Boolean flag = (Boolean)itFlag.next();
                if (flag.booleanValue()) {
                    String foldPath = filePath + this.resolver.getSeparator() + name;
                    Object foldObject = this.loadFolder(parent, name, foldPath);
                    this.scan(foldObject, foldPath);
                    continue;
                }
                String tmpPath = path.toLowerCase();
                if (!tmpPath.endsWith(this.getFileFilter()) || this.filter != null && !this.filter.isAccepted(name)) continue;
                String string = fp = this.resolver.isListAbsolutePath() ? path : filePath + this.resolver.getSeparator() + path;
                if (this.service != null) {
                    Future<?> futureTask = this.service.submit(() -> {
                        try {
                            this.loadMetaData(parent, filePath, fp, name);
                        }
                        catch (Throwable e) {
                            LogSvr.getInstance().error("read file error : " + name, e);
                            throw new RuntimeException(e);
                        }
                    });
                    this.futureTaskList.add(futureTask);
                    continue;
                }
                this.loadMetaData(parent, filePath, fp, name);
            }
        }
    }

    protected String getFileFilter() {
        return this.fileFilter;
    }

    public abstract void loadMetaData(Object var1, String var2, String var3, String var4) throws Exception;
}

