package com.bokesoft.yigo.meta.taskflow.node;

import com.bokesoft.yes.meta.persist.dom.taskflow.NodeType;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;

/**
 * 任务配置对象
 */
public class MetaTask extends MetaNode {

	public final static String TAG_NAME = "Task";
	
	/** 任务关联名称*/
	private String taskName = null;
	/** 二开实现类名*/
	private String impl = null;
	
	/**
	 * 获取任务关联名称
	 * @return 任务关联名称
	 */
	public String getTaskName() {
		return this.taskName;
	}
	
	/**
	 * 设置任务关联名称
	 * @param taskName 任务关联名称
	 */
	public void setTaskName(String taskName) {
		this.taskName = taskName;
	}
	
	/**
	 * 获取二开实现类名
	 * @return 二开实现类名
	 */
	public String getImpl() {
		return this.impl;
	}
	
	/**
	 * 设置二开实现类名
	 * @param impl 二开实现类名
	 */
	public void setImpl(String impl) {
		this.impl = impl;
	}
	
	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public int getNodeType() {
		return NodeType.TASK;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaTask();
	}
	
	@Override
	public AbstractMetaObject clone() {
		MetaTask clone = (MetaTask) super.clone();
		clone.setImpl(impl);
		clone.setTaskName(taskName);
		return clone;
	}
}
	
