package com.bokesoft.yigo.meta.taskflow.node;

import java.util.LinkedList;

import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.KeyPairMetaObject;
import com.bokesoft.yigo.meta.base.MetaException;

/**
 * 参数定义
 */
public class MetaPara extends KeyPairMetaObject {
	
	public static final String TAG_NAME = "Para";
	
	/** 唯一标识 */
	private String key = null;
	/** 参数类型*/
	private Integer type = 0;
	/** 参数值 */
	private String value = null;
	
	@Override
	public String getKey() {
		return this.key;
	}
	
	public void setKey(String key) {
		this.key = key;
	}
	
	/**
	 * 获取参数类型
	 * @return 参数类型
	 */
	public Integer getType() {
		return this.type;
	}
	
	/**
	 * 设置参数类型
	 * @param type 参数类型
	 */
	public void setType(Integer type) {
		this.type = type;
	}
	
	/**
	 * 获取参数值
	 * @return 参数值
	 */
	public String getValue() {
		return this.value;
	}
	
	/**
	 * 设置参数值
	 * @param value 参数值
	 */
	public void setValue(String value) {
		this.value = value;
	}
	
	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node, String tagName, Object flag,
			int runType) throws MetaException {
		return null;
	}

	@Override
	public AbstractMetaObject clone() {
		MetaPara clone = new MetaPara();
		clone.setKey(key);
		clone.setType(type);
		clone.setValue(value);
		return clone;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaPara();
	}

}
