package com.bokesoft.yigo.meta.taskflow.node;

import java.util.LinkedList;

import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;

/**
 * 条件节点
 */
public class MetaCondition extends AbstractMetaObject {
	
	public final static String TAG_NAME = "Condition";
	
	/**
	 * 条件内容
	 */
	private String content = null;
	
	/**
	 * 获取条件
	 * @return 条件
	 */
	public String getContent() {
		return this.content;
	}
	
	/**
	 * 设置条件
	 * @param content 条件
	 */
	public void setContent(String content) {
		this.content = content;
	}
	
	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node, String tagName, Object flag,
			int runType) throws MetaException {
		MetaCondition clone = new MetaCondition();
		clone.setContent(content);
		return clone;
	}

	@Override
	public AbstractMetaObject clone() {
		MetaCondition clone = (MetaCondition) newInstance();
		clone.setContent(content);
		return clone;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaCondition();
	}
}
