package com.bokesoft.yigo.meta.taskflow;

import org.json.JSONObject;

import com.bokesoft.yes.meta.i18n.StringTable;
import com.bokesoft.yes.meta.persist.dom.DomMetaConstants;
import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yes.meta.persist.dom.solution.BaseMetaScanLoad;
import com.bokesoft.yigo.common.util.SimpleStringFormat;
import com.bokesoft.yigo.meta.base.IMetaResolver;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.solution.MetaProject;

public class MetaTaskFlowScanLoad extends BaseMetaScanLoad {
	
	private MetaTaskFlowList flowList = null;
	
	public MetaTaskFlowScanLoad(MetaTaskFlowList flowList, IMetaResolver resolver, MetaProject metaProject, Object context, int runType) {
		super(resolver, metaProject, DomMetaConstants.TASKFLOW_FOLD, context);
		this.flowList = flowList;
	}

	protected void doFind(Object parent, String parentPath, String filePath, String fileName, MetaTaskFlowProfile profile) {
		
	}
	
	@Override
	public void loadMetaData(Object parent, String parentPath, String filePath, String fileName) throws Exception {
		JSONObject profileInfo = resolver.readProfile(filePath, 0);
		if (profileInfo != null) {
			String tagName = profileInfo.optString(MetaConstants.COMMON_TAG_NAME);
			if (MetaTaskFlow.TAG_NAME.equals(tagName)) {
				MetaTaskFlowProfile flowProfile = new MetaTaskFlowProfile();
				flowProfile.setKey(profileInfo.optString(MetaConstants.COMMON_KEY));
				flowProfile.setCaption(profileInfo.optString(MetaConstants.COMMON_CAPTION));
				flowProfile.setResource(filePath);
				flowProfile.setProject(metaProject);
				if (flowList.containsKey(flowProfile.getKey())) {
					throw new MetaException(MetaException.REPEAT_FORM_DEFINED,
							SimpleStringFormat.format(
									StringTable.getString(null, "", StringTable.RepeatFormDefined),
									metaProject.getKey(), flowProfile.getKey()));
				}
				doFind(parent, parentPath, filePath, fileName, flowProfile);
				flowList.add(flowProfile);
			}
		}
	}

}
