package com.bokesoft.yigo.meta.schema;

import java.util.LinkedList;

import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.KeyPairMetaObject;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.dataobject.MetaTable;
import com.bokesoft.yigo.meta.form.IPropertyMerger;

/**
 * 表格中定义的索引
 */
public class MetaIndex extends KeyPairMetaObject implements IPropertyMerger<MetaIndex> {
	/** 列的标签名 */
	public static final String TAG_NAME = "Index";
	/** 索引的标识 */
	private String key = "";
	/** 索引包含的列，以逗号（,）分隔 */
	private String columns = "";
	/** 索引的描述 */
	private String description = "";
	/** 是否唯一索引 */
	private Boolean isUnique = false;

	public String getKey() {
		return key;
	}

	public void setKey(String key) {
		this.key = key;
	}

	public String getColumns() {
		return columns;
	}

	public void setColumns(String columns) {
		this.columns = columns;
	}

	public String getDescription() {
		return description;
	}

	public void setDescription(String description) {
		this.description = description;
	}

	public Boolean isUnique() {
		return isUnique;
	}

	public void setUnique(Boolean isUnique) {
		this.isUnique = isUnique;
	}

	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
	}

	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node, String tagName, Object flag, int runType) throws MetaException {
		return null;
	}

	@Override
	public AbstractMetaObject clone() {
		MetaIndex newObject = new MetaIndex();
		newObject.setKey(key);
		newObject.setColumns(columns);
		newObject.setDescription(description);
		newObject.setUnique(isUnique);

		return newObject;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaIndex();
	}

	@Override
	public void merge(MetaIndex metaIndex) {
		if (metaIndex.columns != null) {
			this.columns = metaIndex.columns;
		}
		if (metaIndex.description != null) {
			this.description = metaIndex.description;
		}
		if (metaIndex.isUnique != null) {
			this.isUnique = metaIndex.isUnique;
		}

	}
}
