package com.bokesoft.yigo.meta.report.embed;

import java.util.LinkedList;

import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.report.MetaReportDisplay;
import com.bokesoft.yigo.meta.report.ReportContentSourceType;

public class MetaReportText extends MetaReportEmbedObject {
	/** 标识 */
	private String key = "";
	/** 名称 */
	private String caption = "";
	/** 来源类型 */
	private Integer sourceType = ReportContentSourceType.Const;
	/** 表标识 */
	private String tableKey = "";
	/** 字段标识 */
	private String fieldKey = "";
	/** 表达式内容 */
	private String formula = "";
	/** Java代码实现的来源类名称 */
	private String impl = "";
	/** 背景色 */
	private String backColor = "";
	/** 前景色 */
	private String foreColor = "#000000";
	/** 显示属性 */
	private MetaReportDisplay display = null;
	/** 是否套打内容 */
	private Boolean fillEmptyContent = false;
	/** 系统域 */
	private Integer systemContent = -1;
	/** 页码 */
	private Integer pageNo = -1;
	
	public MetaReportText() {
		super();
	}
	
	@Override
	public int getCompositeType() {
		return ReportEmbedType.Text;
	}

	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		this.addAll2(list, this.display);
	}
	
	/**
	 * 设置标识
	 * @param key 标识
	 */
	public void setKey(String key) {
		this.key = key;
	}
	
	/**
	 * 取得标识
	 * @return 标识
	 */
	public String getKey() {
		return this.key;
	}
	
	/**
	 * 设置名称
	 * @param caption 名称
	 */
	public void setCaption(String caption) {
		this.caption = caption;
	}
	
	/**
	 * 取得名称
	 * @return 名称
	 */
	public String getCaption() {
		return this.caption;
	}
	
	/**
	 * 设置内容来源类型
	 * @param sourceType 内容来源类型 
	 */
	public void setSourceType(Integer sourceType) {
		this.sourceType = sourceType;
	}
	
	/**
	 * 取得内容来源类型
	 * @return 内容来源类型
	 */
	public Integer getSourceType() {
		return this.sourceType;
	}
	
	/**
	 * 设置表标识
	 * @param tableKey 表标识
	 */
	public void setTableKey(String tableKey) {
		this.tableKey = tableKey;
	}
	
	/**
	 * 取得表标识
	 * @return 表标识
	 */
	public String getTableKey() {
		return this.tableKey;
	}
	
	/**
	 * 设置字段标识
	 * @param fieldKey 字段标识
	 */
	public void setFieldKey(String fieldKey) {
		this.fieldKey = fieldKey;
	}
	
	/**
	 * 取得字段标识
	 * @return 字段标识
	 */
	public String getFieldKey() {
		return this.fieldKey;
	}
	
	/**
	 * 设置表达式
	 * @param formula 表达式
	 */
	public void setFormula(String formula) {
		this.formula = formula;
	}
	
	/**
	 * 取得表达式
	 * @return 表达式
	 */
	public String getFormula() {
		return this.formula;
	}
	
	/**
	 * 设置java实现
	 * @param impl java实现类名
	 */
	public void setImpl(String impl) {
		this.impl = impl;
	}
	
	/**
	 * 取得java实现
	 * @return java实现类名
	 */
	public String getImpl() {
		return this.impl;
	}
	
	/**
	 * 设置背景色
	 * @param backColor 背景色
	 */
	public void setBackColor(String backColor) {
		this.backColor = backColor;
	}
	
	/**
	 * 取得背景色
	 * @return 背景色
	 */
	public String getBackColor() {
		return this.backColor;
	}
	
	/**
	 * 设置前景色
	 * @param foreColor 前景色
	 */
	public void setForeColor(String foreColor) {
		this.foreColor = foreColor;
	}
	
	/**
	 * 取得前景色
	 * @return 前景色
	 */
	public String getForeColor() {
		return this.foreColor;
	}
	
	/**
	 * 设置显示属性
	 * @param display 显示属性
	 */
	public void setDisplay(MetaReportDisplay display) {
		this.display = display;
	}
	
	/**
	 * 取得显示属性
	 * @return 显示属性
	 */
	public MetaReportDisplay getDisplay() {
		return this.display;
	}
	
	/**
	 * 设置是否套打
	 * @param fillEmptyContent
	 */
	public void setFillEmptyContent(Boolean fillEmptyContent) {
		this.fillEmptyContent = fillEmptyContent;
	}
	
	/**
	 * 获取是否套打
	 * @return
	 */
	public Boolean isFillEmptyContent() {
		return this.fillEmptyContent;
	}
	
	public void setPageNo(Integer pageNo) {
		this.pageNo = pageNo;
	}
	
	public Integer getPageNo() {
		return this.pageNo;
	}
	
	public void setSystemContent(Integer systemContent) {
		this.systemContent = systemContent;
	}
	
	public Integer getSystemContent() {
		return this.systemContent;
	}

	public static final String TAG_NAME = "Text";
	
	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc,
			Object node, String tagName, Object flag, int runType) throws MetaException {
		AbstractMetaObject resultMetaObject = null;
		if ( MetaReportDisplay.TAG_NAME.equals(tagName) ) {
			display = new MetaReportDisplay();
			resultMetaObject = display;
		}
		return resultMetaObject;
	}

	@Override
	public AbstractMetaObject clone() {
		// TODO Auto-generated method stub
		MetaReportText newText = new MetaReportText();
		newText.setX(super.getX());
		newText.setY(super.getY());
		newText.setWidth(super.getWidth());
		newText.setHeight(super.getHeight());
		
		newText.setKey(key);
		newText.setCaption(caption);
		newText.setSourceType(sourceType);
		newText.setTableKey(tableKey);
		newText.setFieldKey(fieldKey);
		newText.setFormula(formula);
		newText.setImpl(impl);
		newText.setBackColor(backColor);
		newText.setForeColor(foreColor);
		newText.setDisplay(display == null ? null : (MetaReportDisplay) display.clone()); 
		newText.setPageNo(pageNo);
		newText.setSystemContent(systemContent);
		return newText;
	}

	@Override
	public AbstractMetaObject newInstance() {
		// TODO Auto-generated method stub
		return new MetaReportText();
	}

}
