package com.bokesoft.yigo.meta.report;

import java.util.LinkedList;

import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;

/**
 * MetaReportGridSection定义打印报表的区段
 * @author wangyh
 *
 */
public class MetaReportGridSection extends AbstractMetaObject {
	/** 区段的标识 */
	private String key = "";
	/** 区段的名称 */
	private String caption = "";
	/** 区段的类型 */
	private Integer type = -1;
	/** 列集合 */
	private MetaReportGridColumns columns = null;
	/** 行集合 */
	private MetaReportGridRows rows = null;
	/** 最小明细填充数据行数 */
	private Integer minFillRowCount = 0;
	/** 分页策略 */
	private Integer pageBreakPolicy = ReportTablePageBreakPolicy.None;
	/** 是否支持明细拆行 */
	private Boolean splitRow = false;

	public static final String TAG_NAME = "Section";
	
	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc,
			Object node, String tagName, Object flag, int runType) throws MetaException {
		if (tagName.equalsIgnoreCase(MetaReportGridColumns.TAG_NAME)) {
			columns = new MetaReportGridColumns();
			return columns;
		} else if (tagName.equalsIgnoreCase(MetaReportGridRows.TAG_NAME)) {
			rows = new MetaReportGridRows();
			return rows;
		} else {
			throw new MetaException(MetaException.NO_ACTION_DEFINED,
					"No action defined for " + tagName);
		}
	}
	
	/**
	 * 设置区段标识
	 * @param key 区段标识
	 */
	public void setKey(String key) {
		this.key = key;
	}
	
	/**
	 * 取得区段标识
	 * @return 区段标识
	 */
	public String getKey() {
		return this.key;
	}
	
	/**
	 * 设置区段名称
	 * @param caption 区段名称
	 */
	public void setCaption(String caption) {
		this.caption = caption;
	}
	
	/**
	 * 取得区段名称
	 * @return 区段名称
	 */
	public String getCaption() {
		return this.caption;
	}
	
	/**
	 * 设置区段类型
	 * @param type 区段类型
	 */
	public void setType(Integer type) {
		this.type = type;
	}
	
	/**
	 * 取得区段类型
	 * @return 区段类型
	 */
	public Integer getType() {
		return this.type;
	}
	
	/**
	 * 设置列集合
	 * @param columns 列集合
	 */
	public void setColumns(MetaReportGridColumns columns) {
		this.columns = columns;
	}
	
	/**
	 * 取得列集合
	 * @return 列集合
	 */
	public MetaReportGridColumns getColumns() {
		return this.columns;
	}
	
	/**
	 * 设置行集合
	 * @param rows 行集合
	 */
	public void setRows(MetaReportGridRows rows) {
		this.rows = rows;
	}
	
	/**
	 * 取得行集合
	 * @return 行集合
	 */
	public MetaReportGridRows getRows() {
		return this.rows;
	}
	
	/**
	 * 设置最小明细填充行数
	 * @param minFillRowCount 最小明细填充行数
	 */
	public void setMinFillRowCount(Integer minFillRowCount) {
		this.minFillRowCount = minFillRowCount;
	}
	
	/**
	 * 取得最小明细填充行数
	 * @return 最小明细填充行数
	 */
	public Integer getMinFillRowCount() {
		return this.minFillRowCount;
	}
	
	/**
	 * 设置分页策略
	 * @param pageBreakPolicy 分页策略
	 */
	public void setPageBreakPolicy(Integer pageBreakPolicy) {
		this.pageBreakPolicy = pageBreakPolicy;
	}
	
	/**
	 * 取得分页策略
	 * @return 分页策略
	 */
	public Integer getPageBreakPolicy() {
		return this.pageBreakPolicy;
	}
	
	/**
	 * 设置是否拆行
	 * @param splitRow 标志
	 */
	public void setSplitRow(Boolean splitRow) {
		this.splitRow = splitRow;
	}
	
	/**
	 * 取得是否拆行标志
	 * @return 标志
	 */
	public Boolean isSplitRow() {
		return this.splitRow;
	}

	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		this.addAll2(list, this.columns, this.rows);
	}

	@Override
	public AbstractMetaObject clone() {
		MetaReportGridSection newObject = new MetaReportGridSection();
		newObject.setKey(key);
		newObject.setCaption(caption);
		newObject.setType(type);
		newObject.setColumns(columns == null ? null : (MetaReportGridColumns) columns.clone());
		newObject.setRows(rows == null ? null : (MetaReportGridRows) rows.clone());
		newObject.setMinFillRowCount(minFillRowCount);
		newObject.setPageBreakPolicy(pageBreakPolicy);
		newObject.setSplitRow(splitRow);
		
		return newObject;
	}

	@Override
	public AbstractMetaObject newInstance() {
		// TODO Auto-generated method stub
		return new MetaReportGridSection();
	}

	public void clear() {
		if ( this.columns != null ) {
			this.columns.clear();
		}
		if ( this.rows != null ) {
			this.rows.clear();
		}
	}
}
