package com.bokesoft.yigo.meta.report;

import java.util.LinkedList;

import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;

public class MetaReportGridColumn extends AbstractMetaObject {
	public static final String TAG_NAME = "Column";
	
	/** 列类型 */
	private Integer type = ReportColumnType.Fix;
	/** 列宽 */
	private int width = 0;
	/** 列可见性 */
	private String visible = "";
	/** 列扩展标识 */
	private String expandKey = "";
	/** 横向锁定标志 */
	private Boolean lock = false;
	/** 列超出页宽时，判定是否需要折行 */
	private Boolean needDetermineRowWrap = false;

	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc,
			Object node, String tagName, Object flag, int runType) throws MetaException {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		// TODO Auto-generated method stub

	}
	
	/**
	 * 设置列类型
	 * @param type 列类型
	 * @see ReportColumnType
	 */
	public void setType(Integer type) {
		this.type = type;
	}
	
	/**
	 * 取得列类型
	 * @return 列类型
	 * @see ReportColumnType
	 */
	public Integer getType() {
		return this.type;
	}
	
	/**
	 * 设置列宽
	 * @param width 列宽
	 */
	public void setWidth(int width) {
		this.width = width;
	}
	
	/**
	 * 取得列宽
	 * @return 列宽
	 */
	public int getWidth() {
		return this.width;
	}
	
	/**
	 * 设置列可见性
	 * @param visible 可见性条件
	 */
	public void setVisible(String visible) {
		this.visible = visible;
	}
	
	/**
	 * 取得列可见性
	 * @return 可见性条件
	 */
	public String getVisible() {
		return this.visible;
	}
	
	/**
	 * 所属列扩展标识
	 * @param expandKey 列扩展标识
	 */
	public void setExpandKey(String expandKey) {
		this.expandKey = expandKey;
	}
	
	/**
	 * 取得所属列扩展标识
	 * @return 列扩展标识
	 */
	public String getExpandKey() {
		return this.expandKey;
	}
	
	/**
	 * 设置横向锁定
	 * @param lock 横向锁定标志
	 */
	public void setLock(Boolean lock) {
		this.lock = lock;
	}
	
	/**
	 * 取得横向锁定
	 * @return 横向锁定标志
	 */
	public Boolean isLock() {
		return this.lock;
	}
	
	/**
	 * 列超出页宽时判定是否需要折行
	 * @return
	 */
	public Boolean isNeedDetermineRowWrap() {
		return this.needDetermineRowWrap;
	}
	
	/**
	 * 设置列超出页宽时是否需要折行
	 * @param needDetermineRowWrap
	 */
	public void setNeedDetermineRowWrap(Boolean needDetermineRowWrap) {
		this.needDetermineRowWrap = needDetermineRowWrap;
	}

	@Override
	public AbstractMetaObject clone() {
		// TODO Auto-generated method stub
		MetaReportGridColumn newColumn = new MetaReportGridColumn();
		newColumn.setType(type);
		newColumn.setWidth(width);
		newColumn.setVisible(visible);
		newColumn.setExpandKey(expandKey);
		newColumn.setLock(lock);
		newColumn.setNeedDetermineRowWrap(needDetermineRowWrap);
		return newColumn;
	}

	@Override
	public AbstractMetaObject newInstance() {
		// TODO Auto-generated method stub
		return new MetaReportGridColumn();
	}

}
