package com.bokesoft.yigo.meta.report;

import java.util.LinkedList;

import com.bokesoft.yigo.common.def.HAlignment;
import com.bokesoft.yigo.common.def.VAlignment;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;

/**
 * MetaReportDisplay定义报表中的单元格的显示相关的属性
 * @author wangyh
 *
 */
public class MetaReportDisplay extends AbstractMetaObject {
	/** 字体 */
	private MetaReportFont font = null;
	/** 格式 */
	private MetaReportFormat format = null;
	/** 边框 */
	private MetaReportBorder border = null;
	/** 图片 */
	private MetaReportImageStyle imageStyle = null;
	/** 水平对齐方式 */
	private Integer hAlign = HAlignment.CENTER;
	/** 垂直对齐方式 */
	private Integer vAlign = VAlignment.CENTER;
	/** 背景色 */
	private String backColor = "";
	/** 前景色 */
	private String foreColor = "";
	/** 显示类型 */
	private String showType = "";
	/** 编码方式，目前用于文本的图形显示，如二维码 */
	private String encodingType = "UTF-8";
	/** 二维码的纠错级别  */
	private String errorCorrectionLevel = "L";
	/** 二维码边距 */
	private Integer margin = 0;
	/** 定义零值显示 */
	private Boolean enableZeroShow = false;
	/** 零值显示字符串 */
	private String zeroShowString = "";
	
	public MetaReportDisplay() {
		super();
	}
	
	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		this.addAll2(list, this.font, this.format, this.border, this.imageStyle);
	}

	public static final String TAG_NAME = "Display";
	
	@Override
	public String getTagName() {
		return TAG_NAME;
	}
	
	/**
	 * 设置字体
	 * @param font 字体
	 */
	public void setFont(MetaReportFont font) {
		this.font = font;
	}
	
	/**
	 * 取得字体
	 * @return 字体
	 */
	public MetaReportFont getFont() {
		return this.font;
	}
	
	/**
	 * 取得字体，为null的时候创建一个空的
	 * @return 字体
	 */
	public MetaReportFont ensureFont() {
		if ( this.font == null ) {
			this.font = new MetaReportFont();
		}
		return this.font;
	}
	
	/**
	 * 设置格式
	 * @param format 格式
	 */
	public void setFormat(MetaReportFormat format) {
		this.format = format;
	}
	
	/**
	 * 取得格式
	 * @return 格式
	 */
	public MetaReportFormat getFormat() {
		return this.format;
	}
	
	/**
	 * 取得格式，如果不存在，则创建一个
	 * @return 格式
	 */
	public MetaReportFormat ensureFormat() {
		if (this.format == null)
			this.format = new MetaReportFormat();
		return this.format;
	}
	
	/**
	 * 设置边框
	 * @param border 边框
	 */
	public void setBorder(MetaReportBorder border) {
		this.border = border;
	}
	
	/**
	 * 取得边框
	 * @return 边框
	 */
	public MetaReportBorder getBorder() {
		return this.border;
	}
	
	/**
	 * 取得边框，如果不存在，则创建一个
	 * @return 边框
	 */
	public MetaReportBorder ensureBorder() {
		if ( this.border == null ) {
			this.border = new MetaReportBorder();
		}
		return this.border;
	}
	
	/**
	 * 设置图片样式
	 * @param imageStyle 样式
	 */
	public void setImageStyle(MetaReportImageStyle imageStyle) {
		this.imageStyle = imageStyle;
	}
	
	/**
	 * 取得图片属样式
	 * @return 样式
	 */
	public MetaReportImageStyle getImageStyle() {
		return this.imageStyle;
	}
	
	/**
	 * 取得图片属性，如果不存在，则创建一个
	 * @return 边框
	 */
	public MetaReportImageStyle ensureImageStyle() {
		if ( this.imageStyle == null ) {
			this.imageStyle = new MetaReportImageStyle();
		}
		return this.imageStyle;
	}
	
	
	/**
	 * 设置水平对齐方式
	 * @param hAlign 水平对齐方式
	 */
	public void setHAlign(Integer hAlign) {
		this.hAlign = hAlign;
	}
	
	/**
	 * 取得水平对齐方式
	 * @return 水平对齐方式
	 */
	public Integer getHAlign() {
		return this.hAlign;
	}
	
	/**
	 * 设置垂直对齐方式
	 * @param vAlign 垂直对齐方式
	 */
	public void setVAlign(Integer vAlign) {
		this.vAlign = vAlign;
	}
	
	/**
	 * 取得垂直对齐方式
	 * @return 垂直对齐方式
	 */
	public Integer getVAlign() {
		return this.vAlign;
	}
	
	/**
	 * 取得背景色
	 * @return 背景色
	 */
	public String getBackColor() {
		return backColor;
	}

	/**
	 * 设置背景色
	 * @param backColor 背景色
	 */
	public void setBackColor(String backColor) {
		this.backColor = backColor;
	}

	/**
	 * 取得前景色
	 * @return 前景色
	 */
	public String getForeColor() {
		return foreColor;
	}

	/**
	 * 设置前景色
	 * @param foreColor 前景色
	 */
	public void setForeColor(String foreColor) {
		this.foreColor = foreColor;
	}

	/**
	 * 设置显示方式
	 * @param showType 显示方式
	 */
	public void setShowType(String showType) {
		this.showType = showType;
	}
	
	/**
	 * 取得显示方式
	 * @return 显示方式
	 */
	public String getShowType() {
		return this.showType;
	}
	
	/**
	 * 设置编码方式
	 * 
	 * @param encodingType 编码方式
	 */
	public void setEncodingType(String encodingType) {
		this.encodingType = encodingType;
	}
	
	/**
	 * 获取编码方式 
	 * @return 编码方式
	 */
	public String getEncodingType() {
		return this.encodingType;
	}
	
	/**
	 * 设置二维码纠错级别
	 * @param level 级别
	 */
	public void setErrorCorrectionLevel(String level) {
		this.errorCorrectionLevel = level;
	}
	
	/**
	 * 取得二维码纠错级别
	 * @return 级别
	 */
	public String getErrorCorrectionLevel() {
		return this.errorCorrectionLevel;
	}
	
	/**
	 * 设置二维码边距
	 * @param margin 边距
	 */
	public void setMargin(Integer margin) {
		this.margin = margin;
	}
	
	/**
	 * 取得二维码边距
	 * @return 边距
	 */
	public Integer getMargin() {
		return this.margin;
	}
	
	/**
	 * 设置定义零值显示
	 * @param enableZeroShow 标志
	 */
	public void setEnableZeroShow(Boolean enableZeroShow) {
		this.enableZeroShow = enableZeroShow;
	}
	
	/**
	 * 取得定义零值显示标志
	 * @return 标志
	 */
	public Boolean isEnableZeroShow() {
		return this.enableZeroShow;
	}
	
	/**
	 * 设置零值显示字符串
	 * @param zeroShowString 零值显示字符串
	 */
	public void setZeroShowString(String zeroShowString) {
		this.zeroShowString = zeroShowString;
	}
	
	/**
	 * 取得零值显示字符串
	 * @return 零值显示字符串
	 */
	public String getZeroShowString() {
		return this.zeroShowString;
	}
	
	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc,
			Object node, String tagName, Object flag, int runType) throws MetaException {
		AbstractMetaObject resultMetaObject = null;
		if ( MetaReportFont.TAG_NAME.equals(tagName) ) {
			this.font = new MetaReportFont();
			resultMetaObject = this.font;
		} else if ( MetaReportFormat.TAG_NAME.equals(tagName) ) {
			this.format = new MetaReportFormat();
			resultMetaObject = this.format;
		} else if ( MetaReportBorder.TAG_NAME.equals(tagName) ) {
			this.border = new MetaReportBorder();
			resultMetaObject = this.border;
		} else if ( MetaReportImageStyle.TAG_NAME.equals(tagName) ) {
			this.imageStyle = new MetaReportImageStyle();
			resultMetaObject = this.imageStyle;
		}
		return resultMetaObject;
	}

	@Override
	public AbstractMetaObject clone() {
		MetaReportDisplay newObject = (MetaReportDisplay)newInstance();
		newObject.setFont(this.font == null ? null : (MetaReportFont)this.font.clone());
		newObject.setFormat(this.format == null ? null : (MetaReportFormat)this.format.clone());
		newObject.setBorder(this.border == null ? null : (MetaReportBorder)this.border.clone());
		newObject.setImageStyle(this.imageStyle == null ? null : (MetaReportImageStyle)this.imageStyle.clone());
		newObject.setHAlign(hAlign);
		newObject.setVAlign(vAlign);
		newObject.setBackColor(backColor);
		newObject.setForeColor(foreColor);
		newObject.setShowType(showType);
		newObject.setEncodingType(encodingType);
		newObject.setErrorCorrectionLevel(errorCorrectionLevel);
		newObject.setMargin(margin);
		newObject.setEnableZeroShow(enableZeroShow);
		newObject.setZeroShowString(zeroShowString);
		return newObject;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaReportDisplay();
	}

}
