package com.bokesoft.yigo.meta.report;

import java.util.LinkedList;

import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.GenericKeyCollectionWithKey;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.dataobject.MetaTable;

public class MetaReportDataSource extends
		GenericKeyCollectionWithKey<MetaReportDataTable> {
	public static final String TAG_NAME = "DataSource";

	/** 报表的标识 */
	private String key = null;

	@Override
	public String getKey() {
		return key;
	}
	
	/**
	 * 取得数据源标识
	 * @param key 数据源标识
	 */
	public void setKey(String key) {
		this.key = key;
	}

	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc,
			Object node, String tagName, Object flag, int runType) throws MetaException {
		AbstractMetaObject resultMetaObject = null;
		if ( MetaTable.TAG_NAME.equals(tagName) ) {
			MetaReportDataTable table = new MetaReportDataTable();
			table.preProcessMetaObject(env, doc, node, flag, runType);
			this.add(table);
			resultMetaObject = table;
		}
		return resultMetaObject;
	}

	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public AbstractMetaObject newInstance() {
		// TODO Auto-generated method stub
		return new MetaReportDataSource();
	}

	@Override
	public AbstractMetaObject clone() {
		// TODO Auto-generated method stub
		MetaReportDataSource newSource = (MetaReportDataSource) super.clone();
		newSource.setKey(key);
		return newSource;
	}

}
