package com.bokesoft.yigo.meta.offlinedef;

import java.util.LinkedList;

import com.bokesoft.yes.common.util.Callback;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;

public class MetaOfflineDef extends AbstractMetaObject{
	
	/** 离线配置信息 */
	MetaConfigInfoCollection offlineinfoCollection = null;

	
	public MetaConfigInfoCollection getOfflineinfoCollection() {
		return offlineinfoCollection;
	}

	public void setOfflineinfoCollection(MetaConfigInfoCollection offlineinfoCollection) {
		this.offlineinfoCollection = offlineinfoCollection;
	}

	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		addAll(list, new Object[] {
				offlineinfoCollection
		});
	}

	public static final String TAG_NAME = "OfflineDef";
	
	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node, String tagName, Object flag,
			int runType) throws MetaException {
		AbstractMetaObject metaObject = null;
		if (MetaConfigInfoCollection.TAG_NAME.equalsIgnoreCase(tagName)) {
			offlineinfoCollection = new MetaConfigInfoCollection();
			metaObject = offlineinfoCollection;
		} 
		return metaObject;
	}

	@Override
	public AbstractMetaObject clone() {
		MetaOfflineDef meta = (MetaOfflineDef) newInstance();
		meta.setOfflineinfoCollection(offlineinfoCollection == null ? null : (MetaConfigInfoCollection)offlineinfoCollection.clone());
		return null;
	}

	@Override
	public AbstractMetaObject newInstance() {
		// TODO Auto-generated method stub
		return new MetaOfflineDef();
	}

	@Override
	public void doPostProcess(int flag, Callback<AbstractMetaObject, Boolean> callback) throws MetaException {
		super.doPostProcess(flag, callback);
		if (offlineinfoCollection != null) {
			offlineinfoCollection.doPostProcess(flag, callback);
		}
	}
}
