package com.bokesoft.yigo.meta.form.component.view.layout;

import java.util.LinkedList;

import com.bokesoft.yes.common.util.Callback;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.GenericKeyCollectionWithKey;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.form.component.MetaFormat;

public abstract class MetaComponentLayout<T extends MetaLayoutItem> extends GenericKeyCollectionWithKey<T> {
	/** 组件的标识 */
	private String key = "";
	
	/** 内边距 */
	private String padding = "";
	/** 左内边距的宽度 */
	private String leftPadding = "";
	/** 右内边距的宽度 */
	private String rightPadding = "";
	/** 上内边距的宽度 */
	private String topPadding = "";
	/** 下内边距的宽度 */
	private String bottomPadding = "";

	/** 外边距 */
	private String margin = "";
	/** 左外边距的宽度 */
	private String leftMargin = "";
	/** 右外边距的宽度 */
	private String rightMargin = "";
	/** 上外边距的宽度 */
	private String topMargin = "";
	/** 下外边距的宽度 */
	private String bottomMargin = "";

	/** 格式 */
	protected MetaFormat format = null;
 
	/** 边框的颜色 */
	private String borderColor = "";
	/** 边框圆角半径 */
	private String borderRadius = "";
	/** 边框宽度 */
	private String borderWidth = "";
	/** 边框样式 */
	private String borderStyle = "";

	public String getPadding() {
		return padding;
	}

	public void setPadding(String padding) {
		this.padding = padding;
	}

	public String getLeftPadding() {
		return leftPadding;
	}

	public void setLeftPadding(String leftPadding) {
		this.leftPadding = leftPadding;
	}

	public String getRightPadding() {
		return rightPadding;
	}

	public void setRightPadding(String rightPadding) {
		this.rightPadding = rightPadding;
	}

	public String getTopPadding() {
		return topPadding;
	}

	public void setTopPadding(String topPadding) {
		this.topPadding = topPadding;
	}

	public String getBottomPadding() {
		return bottomPadding;
	}

	public void setBottomPadding(String bottomPadding) {
		this.bottomPadding = bottomPadding;
	}

	public String getMargin() {
		return margin;
	}

	public void setMargin(String margin) {
		this.margin = margin;
	}

	public String getLeftMargin() {
		return leftMargin;
	}

	public void setLeftMargin(String leftMargin) {
		this.leftMargin = leftMargin;
	}

	public String getRightMargin() {
		return rightMargin;
	}

	public void setRightMargin(String rightMargin) {
		this.rightMargin = rightMargin;
	}

	public String getTopMargin() {
		return topMargin;
	}

	public void setTopMargin(String topMargin) {
		this.topMargin = topMargin;
	}

	public String getBottomMargin() {
		return bottomMargin;
	}

	public void setBottomMargin(String bottomMargin) {
		this.bottomMargin = bottomMargin;
	}

	public MetaFormat getFormat() {
		return format;
	}

	public void setFormat(MetaFormat format) {
		this.format = format;
	}

	public String getBorderColor() {
		return borderColor;
	}

	public void setBorderColor(String borderColor) {
		this.borderColor = borderColor;
	}

	public String getBorderRadius() {
		return borderRadius;
	}

	public void setBorderRadius(String borderRadius) {
		this.borderRadius = borderRadius;
	}

	public String getBorderWidth() {
		return borderWidth;
	}

	public void setBorderWidth(String borderWidth) {
		this.borderWidth = borderWidth;
	}

	public String getBorderStyle() {
		return borderStyle;
	}

	public void setBorderStyle(String borderStyle) {
		this.borderStyle = borderStyle;
	}

	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		if ( format != null ) {
			list.add(format);
		}
	}

	@SuppressWarnings("unchecked")
	@Override
	public void add(MetaLayoutItem value) {
		super.add((T) value);
	}

	/**
	 * 设置组件标识
	 * 
	 * @param key
	 *            标识
	 */
	public void setKey(String key) {
		this.key = key;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node, String tagName, Object flag,
			int runType) throws MetaException {
		AbstractMetaObject resultMetaObject = null;
		 if (tagName.equals(MetaFormat.TAG_NAME)) {
			format = new MetaFormat();
			resultMetaObject = format;
		 } 
		return resultMetaObject;
	}

	@Override
	public AbstractMetaObject clone() {
		MetaComponentLayout<?> newObject = (MetaComponentLayout<?>) super.clone();
		newObject.setKey(key);
		newObject.setFormat(format == null ? null : (MetaFormat)format.clone());
		return newObject;
	}

	@Override
	public void doPostProcess(int flag, Callback<AbstractMetaObject, Boolean> callback) throws MetaException {
		super.doPostProcess(flag, callback);
		for (MetaLayoutItem item : this) {
			item.doPostProcess(flag, callback);
		}
		if ( format != null ) {
			format.doPostProcess(flag, callback);
		}
	}

	@Override
	public String getKey() {
		return key;
	}

	public abstract int getLayoutType();

}
